/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.mapped.BytesUtils;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.Env;

final class MappedFile
implements AutoCloseable {
    private static final int OS_PAGE_SIZE = Env.osPageSize();
    private final MappedByteBuffer buffer;
    private final FileChannel channel;
    private final long address;
    private final ByteBuf byteBufWrapper;
    private final ChannelBufferWrapper channelBufferWrapper;
    private int position;
    private int length;

    private MappedFile(FileChannel channel, MappedByteBuffer byteBuffer, int position, int length) throws IOException {
        this.channel = channel;
        this.buffer = byteBuffer;
        this.position = position;
        this.length = length;
        this.byteBufWrapper = Unpooled.wrappedBuffer((ByteBuffer)this.buffer);
        this.channelBufferWrapper = new ChannelBufferWrapper(this.byteBufWrapper, false);
        this.address = PlatformDependent.directBufferAddress((ByteBuffer)this.buffer);
    }

    public static MappedFile of(File file, int position, int capacity) throws IOException {
        FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        int length = (int)channel.size();
        if (length != capacity && length != 0) {
            channel.close();
            throw new IllegalStateException("the file is not " + capacity + " bytes long!");
        }
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, position, capacity);
        return new MappedFile(channel, buffer, 0, length);
    }

    public FileChannel channel() {
        return this.channel;
    }

    public MappedByteBuffer mapped() {
        return this.buffer;
    }

    public long address() {
        return this.address;
    }

    public void force() {
        this.buffer.force();
    }

    public int read(int position, ByteBuf dst, int dstStart, int dstLength) throws IOException {
        long srcAddress = this.address + (long)position;
        if (dst.hasMemoryAddress()) {
            long dstAddress = dst.memoryAddress() + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)dstLength);
        } else if (dst.hasArray()) {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)dstLength);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        if ((position += dstLength) > this.length) {
            this.length = position;
        }
        return dstLength;
    }

    public int read(int position, ByteBuffer dst, int dstStart, int dstLength) throws IOException {
        long srcAddress = this.address + (long)position;
        if (dst.isDirect()) {
            long dstAddress = PlatformDependent.directBufferAddress((ByteBuffer)dst) + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)dstLength);
        } else {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)dstLength);
        }
        if ((position += dstLength) > this.length) {
            this.length = position;
        }
        return dstLength;
    }

    public int read(ByteBuf dst, int dstStart, int dstLength) throws IOException {
        int remaining = this.length - this.position;
        int read = Math.min(remaining, dstLength);
        long srcAddress = this.address + (long)this.position;
        if (dst.hasMemoryAddress()) {
            long dstAddress = dst.memoryAddress() + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)read);
        } else if (dst.hasArray()) {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)read);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        this.position += read;
        return read;
    }

    public int read(ByteBuffer dst, int dstStart, int dstLength) throws IOException {
        int remaining = this.length - this.position;
        int read = Math.min(remaining, dstLength);
        long srcAddress = this.address + (long)this.position;
        if (dst.isDirect()) {
            long dstAddress = PlatformDependent.directBufferAddress((ByteBuffer)dst) + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)read);
        } else {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)read);
        }
        this.position += read;
        return read;
    }

    public void write(EncodingSupport encodingSupport) throws IOException {
        int encodedSize = encodingSupport.getEncodeSize();
        this.byteBufWrapper.setIndex(this.position, this.position);
        encodingSupport.encode((ActiveMQBuffer)this.channelBufferWrapper);
        this.position += encodedSize;
        assert (this.byteBufWrapper.writerIndex() == this.position);
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    public void write(ByteBuf src, int srcStart, int srcLength) throws IOException {
        long destAddress = this.address + (long)this.position;
        if (src.hasMemoryAddress()) {
            long srcAddress = src.memoryAddress() + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else if (src.hasArray()) {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        this.position += srcLength;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    public void write(ByteBuffer src, int srcStart, int srcLength) throws IOException {
        long destAddress = this.address + (long)this.position;
        if (src.isDirect()) {
            long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)src) + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        }
        this.position += srcLength;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    public void write(int position, ByteBuf src, int srcStart, int srcLength) throws IOException {
        long destAddress = this.address + (long)position;
        if (src.hasMemoryAddress()) {
            long srcAddress = src.memoryAddress() + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else if (src.hasArray()) {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        if ((position += srcLength) > this.length) {
            this.length = position;
        }
    }

    public void write(int position, ByteBuffer src, int srcStart, int srcLength) throws IOException {
        long destAddress = this.address + (long)position;
        if (src.isDirect()) {
            long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)src) + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        }
        if ((position += srcLength) > this.length) {
            this.length = position;
        }
    }

    public void zeros(int position, int count) throws IOException {
        long start = this.address + (long)position;
        long end = start + (long)count;
        int toZeros = count;
        long lastGap = (int)(end & (long)(OS_PAGE_SIZE - 1));
        long lastStartPage = end - lastGap;
        long lastZeroed = end;
        if (start <= lastStartPage && lastGap > 0L) {
            PlatformDependent.setMemory((long)lastStartPage, (long)lastGap, (byte)0);
            lastZeroed = lastStartPage;
            toZeros = (int)((long)toZeros - lastGap);
        }
        while (toZeros >= OS_PAGE_SIZE) {
            assert (BytesUtils.isAligned(lastZeroed, OS_PAGE_SIZE));
            long startPage = lastZeroed - (long)OS_PAGE_SIZE;
            PlatformDependent.setMemory((long)startPage, (long)OS_PAGE_SIZE, (byte)0);
            lastZeroed = startPage;
            toZeros -= OS_PAGE_SIZE;
        }
        if (toZeros > 0) {
            PlatformDependent.setMemory((long)start, (long)toZeros, (byte)0);
        }
        if ((position += count) > this.length) {
            this.length = position;
        }
    }

    public int position() {
        return this.position;
    }

    public void position(int position) {
        this.position = position;
    }

    public long length() {
        return this.length;
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            PlatformDependent.freeDirectBuffer((ByteBuffer)this.buffer);
        }
    }
}

