/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.junit.AbstractActiveMQClientDelegate;
import org.apache.activemq.artemis.junit.ActiveMQProducerOperations;

public class ActiveMQProducerDelegate
extends AbstractActiveMQClientDelegate
implements ActiveMQProducerOperations {
    boolean useDurableMessage = true;
    SimpleString address = null;
    ClientProducer producer;

    protected ActiveMQProducerDelegate(String url, String username, String password) {
        super(url, username, password);
    }

    protected ActiveMQProducerDelegate(String url) {
        super(url);
    }

    protected ActiveMQProducerDelegate(ServerLocator serverLocator, String username, String password) {
        super(serverLocator, username, password);
    }

    protected ActiveMQProducerDelegate(ServerLocator serverLocator) {
        super(serverLocator);
    }

    protected ActiveMQProducerDelegate(String url, String address, String username, String password) {
        this(url, SimpleString.toSimpleString((String)address), username, password);
    }

    protected ActiveMQProducerDelegate(String url, String address) {
        this(url, address, null, null);
    }

    protected ActiveMQProducerDelegate(String url, SimpleString address, String username, String password) {
        super(url, username, password);
        if (address == null) {
            throw new IllegalArgumentException(String.format("%s construction error - address cannot be null", this.getClass().getSimpleName()));
        }
        this.address = address;
    }

    protected ActiveMQProducerDelegate(String url, SimpleString address) {
        this(url, address, null, null);
    }

    protected ActiveMQProducerDelegate(ServerLocator serverLocator, String address, String username, String password) {
        this(serverLocator, SimpleString.toSimpleString((String)address), username, password);
    }

    protected ActiveMQProducerDelegate(ServerLocator serverLocator, String address) {
        this(serverLocator, SimpleString.toSimpleString((String)address));
    }

    protected ActiveMQProducerDelegate(ServerLocator serverLocator, SimpleString address, String username, String password) {
        super(serverLocator, username, password);
        if (address == null) {
            throw new IllegalArgumentException(String.format("%s construction error - address cannot be null", this.getClass().getSimpleName()));
        }
        this.address = address;
    }

    protected ActiveMQProducerDelegate(ServerLocator serverLocator, SimpleString address) {
        this(serverLocator, address, null, null);
    }

    @Override
    public boolean isUseDurableMessage() {
        return this.useDurableMessage;
    }

    @Override
    public void setUseDurableMessage(boolean useDurableMessage) {
        this.useDurableMessage = useDurableMessage;
    }

    @Override
    protected void createClient() {
        try {
            if (!this.session.addressQuery(this.address).isExists() && this.autoCreateQueue) {
                this.log.warn("{}: queue does not exist - creating queue: address = {}, name = {}", new Object[]{this.getClass().getSimpleName(), this.address.toString(), this.address.toString()});
                this.session.createQueue(new QueueConfiguration(this.address));
            }
            this.producer = this.session.createProducer(this.address);
        }
        catch (ActiveMQException amqEx) {
            throw new AbstractActiveMQClientDelegate.ActiveMQClientResourceException(String.format("Error creating producer for address %s", this.address.toString()), (Exception)((Object)amqEx));
        }
    }

    @Override
    protected void stopClient() {
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (ActiveMQException amqEx) {
                this.log.warn("ActiveMQException encountered closing InternalClient ClientProducer - ignoring", (Throwable)amqEx);
            }
            finally {
                this.producer = null;
            }
        }
    }

    @Override
    public ClientMessage createMessage() {
        if (this.session == null) {
            throw new IllegalStateException("ClientSession is null");
        }
        return this.session.createMessage(this.isUseDurableMessage());
    }

    @Override
    public ClientMessage createMessage(byte[] body) {
        ClientMessage message = this.createMessage();
        if (body != null) {
            message.writeBodyBufferBytes(body);
        }
        return message;
    }

    @Override
    public ClientMessage createMessage(String body) {
        ClientMessage message = this.createMessage();
        if (body != null) {
            message.writeBodyBufferString(body);
        }
        return message;
    }

    @Override
    public ClientMessage createMessage(Map<String, Object> properties) {
        ClientMessage message = this.createMessage();
        ActiveMQProducerDelegate.addMessageProperties(message, properties);
        return message;
    }

    @Override
    public ClientMessage createMessage(byte[] body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body);
        ActiveMQProducerDelegate.addMessageProperties(message, properties);
        return message;
    }

    @Override
    public ClientMessage createMessage(String body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body);
        ActiveMQProducerDelegate.addMessageProperties(message, properties);
        return message;
    }

    @Override
    public void sendMessage(ClientMessage message) {
        try {
            this.producer.send((Message)message);
        }
        catch (ActiveMQException amqEx) {
            throw new AbstractActiveMQClientDelegate.ActiveMQClientResourceException(String.format("Failed to send message to %s", this.producer.getAddress().toString()), (Exception)((Object)amqEx));
        }
    }

    @Override
    public ClientMessage sendMessage(byte[] body) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(message);
        return message;
    }

    @Override
    public ClientMessage sendMessage(String body) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(message);
        return message;
    }

    @Override
    public ClientMessage sendMessage(Map<String, Object> properties) {
        ClientMessage message = this.createMessage(properties);
        this.sendMessage(message);
        return message;
    }

    @Override
    public ClientMessage sendMessage(byte[] body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body, properties);
        this.sendMessage(message);
        return message;
    }

    @Override
    public ClientMessage sendMessage(String body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body, properties);
        this.sendMessage(message);
        return message;
    }
}

