/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedActiveMQResource
extends ExternalResource {
    static final String SERVER_NAME = "embedded-server";
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    boolean useDurableMessage = true;
    boolean useDurableQueue = true;
    long defaultReceiveTimeout = 50L;
    Configuration configuration;
    EmbeddedActiveMQ server;
    InternalClient internalClient;

    public EmbeddedActiveMQResource() {
        this.configuration = new ConfigurationImpl().setName(SERVER_NAME).setPersistenceEnabled(false).setSecurityEnabled(false).addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName())).addAddressesSetting("#", new AddressSettings().setDeadLetterAddress(SimpleString.toSimpleString((String)"dla")).setExpiryAddress(SimpleString.toSimpleString((String)"expiry")));
        this.init();
    }

    public EmbeddedActiveMQResource(int serverId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("serverId", serverId);
        TransportConfiguration transportConfiguration = new TransportConfiguration(InVMAcceptorFactory.class.getName(), params);
        this.configuration = new ConfigurationImpl().setName("embedded-server-" + serverId).setPersistenceEnabled(false).setSecurityEnabled(false).addAcceptorConfiguration(transportConfiguration);
        this.init();
    }

    public EmbeddedActiveMQResource(Configuration configuration) {
        this.configuration = configuration;
        this.init();
    }

    public EmbeddedActiveMQResource(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("ActiveMQServer configuration file name cannot be null");
        }
        FileDeploymentManager deploymentManager = new FileDeploymentManager(filename);
        FileConfiguration config = new FileConfiguration();
        deploymentManager.addDeployable((Deployable)config);
        try {
            deploymentManager.readConfiguration();
        }
        catch (Exception ex) {
            throw new EmbeddedActiveMQResourceException(String.format("Failed to read configuration file %s", filename), ex);
        }
        this.configuration = config;
        this.init();
    }

    public static void addMessageProperties(ClientMessage message, Map<String, Object> properties) {
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                message.putObjectProperty(property.getKey(), property.getValue());
            }
        }
    }

    private void init() {
        if (this.server == null) {
            this.server = new EmbeddedActiveMQ().setConfiguration(this.configuration);
        }
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Exception encountered starting %s: %s", this.server.getClass().getName(), this.getServerName()), ex);
        }
        this.configuration = this.server.getActiveMQServer().getConfiguration();
    }

    public void stop() {
        if (this.internalClient != null) {
            this.internalClient.stop();
            this.internalClient = null;
        }
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                this.log.warn(String.format("Exception encountered stopping %s: %s", this.server.getClass().getSimpleName(), this.getServerName()), (Throwable)ex);
            }
        }
    }

    protected void before() throws Throwable {
        this.log.info("Starting {}: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getServerName());
        this.start();
        super.before();
    }

    protected void after() {
        this.log.info("Stopping {}: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getServerName());
        this.stop();
        super.after();
    }

    public boolean isUseDurableMessage() {
        return this.useDurableMessage;
    }

    public void setUseDurableMessage(boolean useDurableMessage) {
        this.useDurableMessage = useDurableMessage;
    }

    public boolean isUseDurableQueue() {
        return this.useDurableQueue;
    }

    public void setUseDurableQueue(boolean useDurableQueue) {
        this.useDurableQueue = useDurableQueue;
    }

    public long getDefaultReceiveTimeout() {
        return this.defaultReceiveTimeout;
    }

    public void setDefaultReceiveTimeout(long defaultReceiveTimeout) {
        this.defaultReceiveTimeout = defaultReceiveTimeout;
    }

    public EmbeddedActiveMQ getServer() {
        return this.server;
    }

    public String getServerName() {
        String name = "unknown";
        ActiveMQServer activeMQServer = this.server.getActiveMQServer();
        if (activeMQServer != null) {
            name = activeMQServer.getConfiguration().getName();
        } else if (this.configuration != null) {
            name = this.configuration.getName();
        }
        return name;
    }

    public String getVmURL() {
        Object vmURL = "vm://0";
        for (TransportConfiguration transportConfiguration : this.configuration.getAcceptorConfigurations()) {
            Map params = transportConfiguration.getParams();
            if (params == null || !params.containsKey("serverId")) continue;
            vmURL = "vm://" + params.get("serverId");
        }
        return vmURL;
    }

    public long getMessageCount(String queueName) {
        return this.getMessageCount(SimpleString.toSimpleString((String)queueName));
    }

    public long getMessageCount(SimpleString queueName) {
        Queue queue = this.locateQueue(queueName);
        if (queue == null) {
            this.log.warn("getMessageCount(queueName) - queue {} not found; returning -1", (Object)queueName.toString());
            return -1L;
        }
        return queue.getMessageCount();
    }

    public Queue locateQueue(String queueName) {
        return this.locateQueue(SimpleString.toSimpleString((String)queueName));
    }

    public Queue locateQueue(SimpleString queueName) {
        return this.server.getActiveMQServer().locateQueue(queueName);
    }

    public List<Queue> getBoundQueues(String address) {
        return this.getBoundQueues(SimpleString.toSimpleString((String)address));
    }

    public List<Queue> getBoundQueues(SimpleString address) {
        if (address == null) {
            throw new IllegalArgumentException("getBoundQueues( address ) - address cannot be null");
        }
        LinkedList<Queue> boundQueues = new LinkedList<Queue>();
        BindingQueryResult bindingQueryResult = null;
        try {
            bindingQueryResult = this.server.getActiveMQServer().bindingQuery(address);
        }
        catch (Exception e) {
            throw new EmbeddedActiveMQResourceException(String.format("getBoundQueues( %s ) - bindingQuery( %s ) failed", address.toString(), address.toString()));
        }
        if (bindingQueryResult.isExists()) {
            for (SimpleString queueName : bindingQueryResult.getQueueNames()) {
                boundQueues.add(this.server.getActiveMQServer().locateQueue(queueName));
            }
        }
        return boundQueues;
    }

    public Queue createQueue(String name) {
        return this.createQueue(SimpleString.toSimpleString((String)name), SimpleString.toSimpleString((String)name));
    }

    public Queue createQueue(String address, String name) {
        return this.createQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)name));
    }

    public Queue createQueue(SimpleString address, SimpleString name) {
        Queue queue = null;
        try {
            queue = this.server.getActiveMQServer().createQueue(new QueueConfiguration(name).setAddress(address).setDurable(Boolean.valueOf(this.isUseDurableQueue())));
        }
        catch (Exception ex) {
            throw new EmbeddedActiveMQResourceException(String.format("Failed to create queue: queueName = %s, name = %s", address.toString(), name.toString()), ex);
        }
        return queue;
    }

    public void createSharedQueue(String name, String user) {
        this.createSharedQueue(SimpleString.toSimpleString((String)name), SimpleString.toSimpleString((String)name), SimpleString.toSimpleString((String)user));
    }

    public void createSharedQueue(String address, String name, String user) {
        this.createSharedQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)name), SimpleString.toSimpleString((String)user));
    }

    public void createSharedQueue(SimpleString address, SimpleString name, SimpleString user) {
        try {
            this.server.getActiveMQServer().createSharedQueue(new QueueConfiguration(name).setAddress(address).setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(this.isUseDurableQueue())).setUser(user));
        }
        catch (Exception ex) {
            throw new EmbeddedActiveMQResourceException(String.format("Failed to create shared queue: queueName = %s, name = %s, user = %s", address.toString(), name.toString(), user.toString()), ex);
        }
    }

    public ClientMessage createMessage() {
        this.getInternalClient();
        return this.internalClient.createMessage(this.isUseDurableMessage());
    }

    public ClientMessage createMessage(byte[] body) {
        this.getInternalClient();
        ClientMessage message = this.internalClient.createMessage(this.isUseDurableMessage());
        if (body != null) {
            message.writeBodyBufferBytes(body);
        }
        return message;
    }

    public ClientMessage createMessage(String body) {
        this.getInternalClient();
        ClientMessage message = this.internalClient.createMessage(this.isUseDurableMessage());
        if (body != null) {
            message.writeBodyBufferString(body);
        }
        return message;
    }

    public ClientMessage createMessageWithProperties(Map<String, Object> properties) {
        this.getInternalClient();
        ClientMessage message = this.internalClient.createMessage(this.isUseDurableMessage());
        EmbeddedActiveMQResource.addMessageProperties(message, properties);
        return message;
    }

    public ClientMessage createMessageWithProperties(byte[] body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body);
        EmbeddedActiveMQResource.addMessageProperties(message, properties);
        return message;
    }

    public ClientMessage createMessageWithProperties(String body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body);
        EmbeddedActiveMQResource.addMessageProperties(message, properties);
        return message;
    }

    public void sendMessage(String address, ClientMessage message) {
        this.sendMessage(SimpleString.toSimpleString((String)address), message);
    }

    public ClientMessage sendMessage(String address, byte[] body) {
        return this.sendMessage(SimpleString.toSimpleString((String)address), body);
    }

    public ClientMessage sendMessage(String address, String body) {
        return this.sendMessage(SimpleString.toSimpleString((String)address), body);
    }

    public ClientMessage sendMessageWithProperties(String address, Map<String, Object> properties) {
        return this.sendMessageWithProperties(SimpleString.toSimpleString((String)address), properties);
    }

    public ClientMessage sendMessageWithProperties(String address, byte[] body, Map<String, Object> properties) {
        return this.sendMessageWithProperties(SimpleString.toSimpleString((String)address), body, properties);
    }

    public ClientMessage sendMessageWithProperties(String address, String body, Map<String, Object> properties) {
        return this.sendMessageWithProperties(SimpleString.toSimpleString((String)address), body, properties);
    }

    public void sendMessage(SimpleString address, ClientMessage message) {
        if (address == null) {
            throw new IllegalArgumentException("sendMessage failure - queueName is required");
        }
        if (message == null) {
            throw new IllegalArgumentException("sendMessage failure - a ClientMessage is required");
        }
        this.getInternalClient();
        this.internalClient.sendMessage(address, message);
    }

    public ClientMessage sendMessage(SimpleString address, byte[] body) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(address, message);
        return message;
    }

    public ClientMessage sendMessage(SimpleString address, String body) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(address, message);
        return message;
    }

    public ClientMessage sendMessageWithProperties(SimpleString address, Map<String, Object> properties) {
        ClientMessage message = this.createMessageWithProperties(properties);
        this.sendMessage(address, message);
        return message;
    }

    public ClientMessage sendMessageWithProperties(SimpleString address, byte[] body, Map<String, Object> properties) {
        ClientMessage message = this.createMessageWithProperties(body, properties);
        this.sendMessage(address, message);
        return message;
    }

    public ClientMessage sendMessageWithProperties(SimpleString address, String body, Map<String, Object> properties) {
        ClientMessage message = this.createMessageWithProperties(body, properties);
        this.sendMessage(address, message);
        return message;
    }

    public ClientMessage receiveMessage(String queueName) {
        return this.receiveMessage(SimpleString.toSimpleString((String)queueName));
    }

    public ClientMessage receiveMessage(String queueName, long timeout) {
        return this.receiveMessage(SimpleString.toSimpleString((String)queueName), timeout);
    }

    public ClientMessage receiveMessage(SimpleString queueName) {
        boolean browseOnly = false;
        return this.getInternalClient().receiveMessage(queueName, this.defaultReceiveTimeout, false);
    }

    public ClientMessage receiveMessage(SimpleString queueName, long timeout) {
        boolean browseOnly = false;
        return this.getInternalClient().receiveMessage(queueName, timeout, false);
    }

    public ClientMessage browseMessage(String queueName) {
        return this.browseMessage(SimpleString.toSimpleString((String)queueName), this.defaultReceiveTimeout);
    }

    public ClientMessage browseMessage(String queueName, long timeout) {
        return this.browseMessage(SimpleString.toSimpleString((String)queueName), timeout);
    }

    public ClientMessage browseMessage(SimpleString queueName) {
        boolean browseOnly = true;
        return this.getInternalClient().receiveMessage(queueName, this.defaultReceiveTimeout, true);
    }

    public ClientMessage browseMessage(SimpleString queueName, long timeout) {
        boolean browseOnly = true;
        return this.getInternalClient().receiveMessage(queueName, timeout, true);
    }

    private InternalClient getInternalClient() {
        if (this.internalClient == null) {
            this.log.info("Creating Internal Client");
            this.internalClient = new InternalClient();
            this.internalClient.start();
        }
        return this.internalClient;
    }

    private class InternalClient {
        ServerLocator serverLocator;
        ClientSessionFactory sessionFactory;
        ClientSession session;
        ClientProducer producer;

        InternalClient() {
        }

        void start() {
            EmbeddedActiveMQResource.this.log.info("Starting {}", (Object)this.getClass().getSimpleName());
            try {
                this.serverLocator = ActiveMQClient.createServerLocator((String)EmbeddedActiveMQResource.this.getVmURL());
                this.sessionFactory = this.serverLocator.createSessionFactory();
            }
            catch (RuntimeException runtimeEx) {
                throw runtimeEx;
            }
            catch (Exception ex) {
                throw new EmbeddedActiveMQResourceException("Internal Client creation failure", ex);
            }
            try {
                this.session = this.sessionFactory.createSession();
                this.producer = this.session.createProducer((String)null);
                this.session.start();
            }
            catch (ActiveMQException amqEx) {
                throw new EmbeddedActiveMQResourceException("Internal Client creation failure", (Exception)((Object)amqEx));
            }
        }

        void stop() {
            if (this.producer != null) {
                try {
                    this.producer.close();
                }
                catch (ActiveMQException amqEx) {
                    EmbeddedActiveMQResource.this.log.warn("ActiveMQException encountered closing InternalClient ClientProducer - ignoring", (Throwable)amqEx);
                }
                finally {
                    this.producer = null;
                }
            }
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (ActiveMQException amqEx) {
                    EmbeddedActiveMQResource.this.log.warn("ActiveMQException encountered closing InternalClient ClientSession - ignoring", (Throwable)amqEx);
                }
                finally {
                    this.session = null;
                }
            }
            if (this.sessionFactory != null) {
                this.sessionFactory.close();
                this.sessionFactory = null;
            }
            if (this.serverLocator != null) {
                this.serverLocator.close();
                this.serverLocator = null;
            }
        }

        public ClientMessage createMessage(boolean durable) {
            this.checkSession();
            return this.session.createMessage(durable);
        }

        public void sendMessage(SimpleString address, ClientMessage message) {
            this.checkSession();
            if (this.producer == null) {
                throw new IllegalStateException("ClientProducer is null - has the InternalClient been started?");
            }
            try {
                this.producer.send(address, (Message)message);
            }
            catch (ActiveMQException amqEx) {
                throw new EmbeddedActiveMQResourceException(String.format("Failed to send message to %s", address.toString()), (Exception)((Object)amqEx));
            }
        }

        public ClientMessage receiveMessage(SimpleString address, long timeout, boolean browseOnly) {
            this.checkSession();
            ClientConsumer consumer = null;
            try {
                consumer = this.session.createConsumer(address, browseOnly);
            }
            catch (ActiveMQException amqEx) {
                throw new EmbeddedActiveMQResourceException(String.format("Failed to create consumer for %s", address.toString()), (Exception)((Object)amqEx));
            }
            ClientMessage message = null;
            if (timeout > 0L) {
                try {
                    message = consumer.receive(timeout);
                }
                catch (ActiveMQException amqEx) {
                    throw new EmbeddedActiveMQResourceException(String.format("ClientConsumer.receive( timeout = %d ) for %s failed", timeout, address.toString()), (Exception)((Object)amqEx));
                }
            }
            if (timeout == 0L) {
                try {
                    message = consumer.receiveImmediate();
                }
                catch (ActiveMQException amqEx) {
                    throw new EmbeddedActiveMQResourceException(String.format("ClientConsumer.receiveImmediate() for %s failed", address.toString()), (Exception)((Object)amqEx));
                }
            }
            try {
                message = consumer.receive();
            }
            catch (ActiveMQException amqEx) {
                throw new EmbeddedActiveMQResourceException(String.format("ClientConsumer.receive() for %s failed", address.toString()), (Exception)((Object)amqEx));
            }
            return message;
        }

        void checkSession() {
            EmbeddedActiveMQResource.this.getInternalClient();
            if (this.session == null) {
                throw new IllegalStateException("ClientSession is null - has the InternalClient been started?");
            }
        }
    }

    public static class EmbeddedActiveMQResourceException
    extends RuntimeException {
        public EmbeddedActiveMQResourceException(String message) {
            super(message);
        }

        public EmbeddedActiveMQResourceException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

