/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.junit.AbstractActiveMQClientDelegate;
import org.apache.activemq.artemis.junit.ActiveMQConsumerDelegate;
import org.apache.activemq.artemis.junit.ActiveMQConsumerOperations;
import org.junit.rules.ExternalResource;

public class ActiveMQConsumerResource
extends ExternalResource
implements ActiveMQConsumerOperations {
    private final ActiveMQConsumerDelegate activeMQConsumer;

    public ActiveMQConsumerResource(String url, String queueName) {
        this.activeMQConsumer = new ActiveMQConsumerDelegate(url, queueName);
    }

    public ActiveMQConsumerResource(String url, String queueName, String username, String password) {
        this.activeMQConsumer = new ActiveMQConsumerDelegate(url, SimpleString.toSimpleString((String)queueName), username, password);
    }

    public ActiveMQConsumerResource(String url, SimpleString queueName, String username, String password) {
        this.activeMQConsumer = new ActiveMQConsumerDelegate(url, queueName, username, password);
    }

    public ActiveMQConsumerResource(String url, SimpleString queueName) {
        this.activeMQConsumer = new ActiveMQConsumerDelegate(url, queueName, null, null);
    }

    public ActiveMQConsumerResource(ServerLocator serverLocator, String queueName, String username, String password) {
        this(serverLocator, SimpleString.toSimpleString((String)queueName), username, password);
    }

    public ActiveMQConsumerResource(ServerLocator serverLocator, String queueName) {
        this(serverLocator, SimpleString.toSimpleString((String)queueName), null, null);
    }

    public ActiveMQConsumerResource(ServerLocator serverLocator, SimpleString queueName, String username, String password) {
        this.activeMQConsumer = new ActiveMQConsumerDelegate(serverLocator, queueName, username, password);
    }

    public ActiveMQConsumerResource(ServerLocator serverLocator, SimpleString queueName) {
        this(serverLocator, queueName, null, null);
    }

    protected void createClient() {
        this.activeMQConsumer.createClient();
    }

    protected void stopClient() {
        this.activeMQConsumer.stopClient();
    }

    public boolean isAutoCreateQueue() {
        return this.activeMQConsumer.isAutoCreateQueue();
    }

    public void setAutoCreateQueue(boolean autoCreateQueue) {
        this.activeMQConsumer.setAutoCreateQueue(autoCreateQueue);
    }

    public ClientMessage receiveMessage() {
        return this.activeMQConsumer.receiveMessage();
    }

    public ClientMessage receiveMessage(long timeout) {
        return this.activeMQConsumer.receiveMessage(timeout);
    }

    protected void before() throws Throwable {
        super.before();
        this.activeMQConsumer.start();
    }

    protected void after() {
        this.activeMQConsumer.stop();
        super.after();
    }

    public static void addMessageProperties(ClientMessage message, Map<String, Object> properties) {
        AbstractActiveMQClientDelegate.addMessageProperties((ClientMessage)message, properties);
    }

    public long getDefaultReceiveTimeout() {
        return this.activeMQConsumer.getDefaultReceiveTimeout();
    }

    public void setDefaultReceiveTimeout(long defaultReceiveTimeout) {
        this.activeMQConsumer.setDefaultReceiveTimeout(defaultReceiveTimeout);
    }
}

