/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class Wait {
    public static final long MAX_WAIT_MILLIS = 30000L;
    public static final int SLEEP_MILLIS = 1000;

    public static boolean waitFor(Condition condition) throws Exception {
        return Wait.waitFor(condition, 30000L);
    }

    public static void assertEquals(long size, LongCondition condition) throws Exception {
        boolean result = Wait.waitFor(() -> condition.getCount() == size);
        if (!result) {
            Assert.fail((String)(size + " != " + condition.getCount()));
        }
    }

    public static void assertEquals(int size, IntCondition condition) throws Exception {
        boolean result = Wait.waitFor(() -> condition.getCount() == size);
        if (!result) {
            Assert.fail((String)(size + " != " + condition.getCount()));
        }
    }

    public static void assertTrue(Condition condition) throws Exception {
        Wait.assertTrue("Condition wasn't met", condition);
    }

    public static void assertFalse(Condition condition) throws Exception {
        Wait.assertTrue(() -> !condition.isSatisfied());
    }

    public static void assertFalse(String failureMessage, Condition condition) throws Exception {
        Wait.assertTrue(failureMessage, () -> !condition.isSatisfied());
    }

    public static void assertTrue(String failureMessage, Condition condition) throws Exception {
        boolean result = Wait.waitFor(condition);
        if (!result) {
            Assert.fail((String)failureMessage);
        }
    }

    public static boolean waitFor(Condition condition, long duration) throws Exception {
        return Wait.waitFor(condition, duration, 1000L);
    }

    public static boolean waitFor(Condition condition, long durationMillis, long sleepMillis) throws Exception {
        long expiry = System.currentTimeMillis() + durationMillis;
        boolean conditionSatisified = condition.isSatisfied();
        while (!conditionSatisified && System.currentTimeMillis() < expiry) {
            TimeUnit.MILLISECONDS.sleep(sleepMillis);
            conditionSatisified = condition.isSatisfied();
        }
        return conditionSatisified;
    }

    public static interface IntCondition {
        public int getCount() throws Exception;
    }

    public static interface LongCondition {
        public long getCount() throws Exception;
    }

    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

