/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnector;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class ThreadLeakCheckRule
extends ExternalResource {
    private static Logger log = Logger.getLogger(ThreadLeakCheckRule.class);
    private static Set<String> knownThreads = new HashSet<String>();
    boolean enabled = true;
    private Map<Thread, StackTraceElement[]> previousThreads;
    private static int failedGCCalls = 0;

    public void disable() {
        this.enabled = false;
    }

    protected void before() throws Throwable {
        this.previousThreads = Thread.getAllStackTraces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after() {
        ActiveMQClient.clearThreadPools();
        InVMConnector.resetThreadPool();
        try {
            if (this.enabled) {
                boolean failed = true;
                boolean failedOnce = false;
                long timeout = System.currentTimeMillis() + 60000L;
                while (failed && timeout > System.currentTimeMillis()) {
                    failed = this.checkThread();
                    if (!failed) continue;
                    failedOnce = true;
                    ThreadLeakCheckRule.forceGC();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Throwable throwable) {}
                }
                if (failed) {
                    Assert.fail((String)"Thread leaked");
                } else if (failedOnce) {
                    System.out.println("******************** Threads cleared after retries ********************");
                    System.out.println();
                }
            } else {
                this.enabled = true;
            }
        }
        finally {
            this.previousThreads = null;
        }
    }

    public static void forceGC() {
        if (failedGCCalls >= 10) {
            log.info((Object)"ignoring forceGC call since it seems System.gc is not working anyways");
            return;
        }
        log.info((Object)"#test forceGC");
        CountDownLatch finalized = new CountDownLatch(1);
        WeakReference<DumbReference> dumbReference = new WeakReference<DumbReference>(new DumbReference(finalized));
        long timeout = System.currentTimeMillis() + 1000L;
        while ((dumbReference.get() != null || finalized.getCount() != 0L) && System.currentTimeMillis() < timeout) {
            System.gc();
            System.runFinalization();
            try {
                finalized.await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (dumbReference.get() != null) {
            ++failedGCCalls;
            log.info((Object)"It seems that GC is disabled at your VM");
        } else {
            failedGCCalls = 0;
        }
        log.info((Object)"#test forceGC Done ");
    }

    public static void removeKownThread(String name) {
        knownThreads.remove(name);
    }

    public static void addKownThread(String name) {
        knownThreads.add(name);
    }

    private boolean checkThread() {
        boolean failedThread = false;
        Map<Thread, StackTraceElement[]> postThreads = Thread.getAllStackTraces();
        if (postThreads != null && this.previousThreads != null && postThreads.size() > this.previousThreads.size()) {
            for (Thread aliveThread : postThreads.keySet()) {
                StackTraceElement[] elements;
                if (!aliveThread.isAlive() || this.isExpectedThread(aliveThread) || this.previousThreads.containsKey(aliveThread)) continue;
                if (!failedThread) {
                    System.out.println("*********************************************************************************");
                    System.out.println("LEAKING THREADS");
                }
                failedThread = true;
                System.out.println("=============================================================================");
                System.out.println("Thread " + aliveThread + " is still alive with the following stackTrace:");
                for (StackTraceElement el : elements = postThreads.get(aliveThread)) {
                    System.out.println(el);
                }
            }
            if (failedThread) {
                System.out.println("*********************************************************************************");
            }
        }
        return failedThread;
    }

    private boolean isExpectedThread(Thread thread) {
        for (String known : knownThreads) {
            if (!thread.getName().contains(known)) continue;
            return true;
        }
        return false;
    }

    protected static class DumbReference {
        private CountDownLatch finalized;

        public DumbReference(CountDownLatch finalized) {
            this.finalized = finalized;
        }

        public void finalize() throws Throwable {
            this.finalized.countDown();
            super.finalize();
        }
    }
}

