/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.junit.AbstractActiveMQClientResource;
import org.apache.activemq.artemis.junit.ActiveMQProducerResource;

public class ActiveMQDynamicProducerResource
extends ActiveMQProducerResource {
    public ActiveMQDynamicProducerResource(String url, String username, String password) {
        super(url, username, password);
    }

    public ActiveMQDynamicProducerResource(String url) {
        super(url);
    }

    public ActiveMQDynamicProducerResource(ServerLocator serverLocator, String username, String password) {
        super(serverLocator, username, password);
    }

    public ActiveMQDynamicProducerResource(ServerLocator serverLocator) {
        super(serverLocator);
    }

    public ActiveMQDynamicProducerResource(String url, SimpleString address, String username, String password) {
        super(url, address, username, password);
    }

    public ActiveMQDynamicProducerResource(String url, SimpleString address) {
        super(url, address);
    }

    public ActiveMQDynamicProducerResource(ServerLocator serverLocator, SimpleString address, String username, String password) {
        super(serverLocator, address, username, password);
    }

    public ActiveMQDynamicProducerResource(ServerLocator serverLocator, SimpleString address) {
        super(serverLocator, address);
    }

    @Override
    protected void createClient() {
        try {
            if (this.address != null && !this.session.addressQuery(this.address).isExists() && this.autoCreateQueue) {
                this.log.warn("queue does not exist - creating queue: address = {}, name = {}", (Object)this.address.toString(), (Object)this.address.toString());
                this.session.createQueue(this.address, this.address);
            }
            this.producer = this.session.createProducer((SimpleString)null);
        }
        catch (ActiveMQException amqEx) {
            if (this.address == null) {
                throw new AbstractActiveMQClientResource.ActiveMQClientResourceException(String.format("Error creating producer for address %s", this.address.toString()), (Exception)((Object)amqEx));
            }
            throw new AbstractActiveMQClientResource.ActiveMQClientResourceException("Error creating producer", (Exception)((Object)amqEx));
        }
    }

    @Override
    public void sendMessage(ClientMessage message) {
        this.sendMessage(this.address, message);
    }

    public void sendMessage(SimpleString targetAddress, ClientMessage message) {
        if (targetAddress == null) {
            throw new IllegalArgumentException(String.format("%s error - address cannot be null", ((Object)((Object)this)).getClass().getSimpleName()));
        }
        try {
            if (this.autoCreateQueue && !this.session.addressQuery(targetAddress).isExists()) {
                this.log.warn("queue does not exist - creating queue: address = {}, name = {}", (Object)this.address.toString(), (Object)this.address.toString());
                this.session.createQueue(targetAddress, targetAddress);
            }
        }
        catch (ActiveMQException amqEx) {
            throw new AbstractActiveMQClientResource.ActiveMQClientResourceException(String.format("Queue creation failed for queue: address = %s, name = %s", this.address.toString(), this.address.toString()));
        }
        try {
            this.producer.send(targetAddress, (Message)message);
        }
        catch (ActiveMQException amqEx) {
            throw new AbstractActiveMQClientResource.ActiveMQClientResourceException(String.format("Failed to send message to %s", targetAddress.toString()), (Exception)((Object)amqEx));
        }
    }

    public ClientMessage sendMessage(SimpleString targetAddress, byte[] body) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(targetAddress, message);
        return message;
    }

    public ClientMessage sendMessage(SimpleString targetAddress, String body) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(targetAddress, message);
        return message;
    }

    public ClientMessage sendMessage(SimpleString targetAddress, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(properties);
        this.sendMessage(targetAddress, message);
        return message;
    }

    public ClientMessage sendMessage(SimpleString targetAddress, byte[] body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(targetAddress, message);
        return message;
    }

    public ClientMessage sendMessage(SimpleString targetAddress, String body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(targetAddress, message);
        return message;
    }
}

