/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.lockmanager.zookeeper;

import org.apache.activemq.artemis.lockmanager.UnavailableStateException;
import org.apache.activemq.artemis.lockmanager.zookeeper.CuratorDistributedLockManager;

public abstract class CuratorDistributedPrimitive
implements AutoCloseable {
    private final CuratorDistributedLockManager manager;
    private final CuratorDistributedLockManager.PrimitiveId id;
    private boolean unavailable;
    private boolean closed;

    protected CuratorDistributedPrimitive(CuratorDistributedLockManager.PrimitiveId id, CuratorDistributedLockManager manager) {
        this.id = id;
        this.manager = manager;
        this.closed = false;
        this.unavailable = false;
        CuratorDistributedLockManager.PrimitiveType.validatePrimitiveInstance(this);
    }

    final CuratorDistributedLockManager.PrimitiveId getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onReconnected() {
        CuratorDistributedLockManager curatorDistributedLockManager = this.manager;
        synchronized (curatorDistributedLockManager) {
            if (this.closed || this.unavailable) {
                return;
            }
            this.handleReconnected();
        }
    }

    protected void handleReconnected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onLost() {
        CuratorDistributedLockManager curatorDistributedLockManager = this.manager;
        synchronized (curatorDistributedLockManager) {
            if (this.closed || this.unavailable) {
                return;
            }
            this.unavailable = true;
            this.handleLost();
        }
    }

    protected void handleLost() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onSuspended() {
        CuratorDistributedLockManager curatorDistributedLockManager = this.manager;
        synchronized (curatorDistributedLockManager) {
            if (this.closed || this.unavailable) {
                return;
            }
            this.handleSuspended();
        }
    }

    protected void handleSuspended() {
    }

    final void onRemoved() {
        this.close(false);
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("This lock is closed");
        }
    }

    protected final void checkUnavailable() throws UnavailableStateException {
        if (this.unavailable) {
            throw new UnavailableStateException(this.id.type + " with id = " + this.id.id + " isn't available");
        }
    }

    protected final void fireUnavailableListener(Runnable task) {
        this.run(() -> {
            if (!this.unavailable) {
                return false;
            }
            this.manager.startHandlingEvents();
            try {
                task.run();
            }
            finally {
                this.manager.completeHandlingEvents();
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <R, T extends Throwable> R run(PrimitiveAction<R, T> action) throws T {
        CuratorDistributedLockManager curatorDistributedLockManager = this.manager;
        synchronized (curatorDistributedLockManager) {
            this.manager.checkHandlingEvents();
            this.checkNotClosed();
            return action.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <R, T extends Throwable> R tryRun(InterruptablePrimitiveAction<R, T> action) throws InterruptedException, T {
        CuratorDistributedLockManager curatorDistributedLockManager = this.manager;
        synchronized (curatorDistributedLockManager) {
            this.manager.checkHandlingEvents();
            this.checkNotClosed();
            return action.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean remove) {
        CuratorDistributedLockManager curatorDistributedLockManager = this.manager;
        synchronized (curatorDistributedLockManager) {
            this.manager.checkHandlingEvents();
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (remove) {
                this.manager.remove(this);
            }
            this.handleClosed();
        }
    }

    protected void handleClosed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isUnavailable() {
        CuratorDistributedLockManager curatorDistributedLockManager = this.manager;
        synchronized (curatorDistributedLockManager) {
            return this.unavailable;
        }
    }

    @Override
    public final void close() {
        this.close(true);
    }

    @FunctionalInterface
    protected static interface InterruptablePrimitiveAction<R, T extends Throwable> {
        public R call() throws InterruptedException, T;
    }

    @FunctionalInterface
    protected static interface PrimitiveAction<R, T extends Throwable> {
        public R call() throws T;
    }
}

