/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.artemis.maven.PluginUtil;
import org.apache.activemq.artemis.maven.TestClusterManager;
import org.apache.activemq.artemis.maven.TestClusterManagerMBean;
import org.apache.activemq.artemis.server.ActiveMQBootstrap;
import org.apache.activemq.artemis.server.SpawnedActiveMQBootstrap;
import org.apache.activemq.artemis.server.SpawnedVMSupport;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;

public class ActiveMQStartPlugin
extends AbstractMojo {
    static final String SKIPBROKERSTART = "skipBrokerStart";
    private PluginDescriptor descriptor;
    private Boolean waitOnStart;
    private String configurationDir;
    private String nodeId;
    private Boolean fork;
    private Boolean debug;
    private Properties systemProperties;
    private String serverStartString;
    private ActiveMQSecurityManager securityManager;
    private boolean testClusterManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String property = System.getProperty(SKIPBROKERSTART);
        if (property != null) {
            this.getLog().info((CharSequence)"skipping Broker Start");
            return;
        }
        if (this.testClusterManager) {
            try {
                this.createClusterManagerMBean();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to create cluster manager mbean", e);
            }
        }
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            System.getProperties().putAll((Map<?, ?>)this.systemProperties);
        }
        String workingPath = new File(".").getAbsolutePath();
        try {
            this.registerNode(this.nodeId, workingPath, this.configurationDir);
        }
        catch (Exception e1) {
            throw new MojoExecutionException("Failed to create cluster manager mbean", e1);
        }
        if (this.fork.booleanValue()) {
            try {
                PluginDescriptor pd = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
                final Process p = SpawnedVMSupport.spawnVM(pd.getArtifacts(), "ActiveMQServer_" + (this.nodeId != null ? this.nodeId : ""), SpawnedActiveMQBootstrap.class.getName(), this.systemProperties, true, this.serverStartString, "FAILED::", ".", this.configurationDir, this.debug, this.configurationDir, "" + this.waitOnStart, this.nodeId);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        p.destroy();
                    }
                });
                if (!this.waitOnStart.booleanValue()) return;
                p.waitFor();
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new MojoExecutionException(e.getMessage());
            }
        }
        ActiveMQBootstrap bootstrap = new ActiveMQBootstrap(this.configurationDir, this.waitOnStart, this.nodeId, this.securityManager);
        if (this.configurationDir != null) {
            this.extendPluginClasspath(this.configurationDir);
        }
        try {
            bootstrap.execute();
            return;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void registerNode(String nodeId, String workingPath, String hornetqConfigurationDir) throws Exception {
        TestClusterManagerMBean control = PluginUtil.getTestClusterManager();
        if (control != null) {
            control.registerNode(nodeId, workingPath, hornetqConfigurationDir);
        }
    }

    private void createClusterManagerMBean() throws Exception {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = ObjectName.getInstance("hornetq:module=test,type=TestClusterManager");
        mbeanServer.registerMBean(new TestClusterManager(), name);
    }

    public void extendPluginClasspath(String element) throws MojoExecutionException {
        ClassRealm realm;
        ClassWorld world = new ClassWorld();
        try {
            realm = world.newRealm("maven.plugin." + ((Object)((Object)this)).getClass().getSimpleName() + (this.nodeId == null ? "" : this.nodeId), Thread.currentThread().getContextClassLoader());
            File elementFile = new File(element);
            this.getLog().debug((CharSequence)("Adding element to plugin classpath" + elementFile.getPath()));
            realm.addConstituent(elementFile.toURI().toURL());
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.toString(), ex);
        }
        System.out.println(Arrays.toString(realm.getConstituents()));
        Thread.currentThread().setContextClassLoader(realm.getClassLoader());
    }
}

