/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.server;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.impl.FileSecurityConfiguration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.config.JMSConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.JMSConfigurationImpl;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.maven.InVMNodeManagerServer;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManagerImpl;

public class ActiveMQBootstrap {
    private final String configurationDir;
    private final Boolean waitOnStart;
    private final String nodeId;
    private static Map<String, NodeManager> managerMap = new HashMap<String, NodeManager>();
    private boolean spawned = false;
    private ActiveMQServer server;
    private Configuration configuration;
    private JMSConfiguration jmsFileConfiguration;
    private SecurityConfiguration securityConfiguration;
    private JMSServerManager manager;
    private ActiveMQSecurityManager securityManager;

    public ActiveMQBootstrap(String configurationDir, Boolean waitOnStart, String nodeId, ActiveMQSecurityManager securityManager) {
        this.configurationDir = configurationDir;
        this.waitOnStart = waitOnStart;
        this.nodeId = nodeId;
        this.securityManager = securityManager;
    }

    public ActiveMQBootstrap(String[] args) {
        this.configurationDir = args[0];
        this.waitOnStart = Boolean.valueOf(args[1]);
        this.nodeId = args[2];
        this.spawned = true;
    }

    public void execute() throws Exception {
        try {
            String dirName;
            if (this.configurationDir != null) {
                this.configuration = new FileConfiguration();
                File file = new File(new File(this.configurationDir), "broker.xml");
                this.jmsFileConfiguration = new FileJMSConfiguration();
                FileDeploymentManager deploymentManager = new FileDeploymentManager(file.toURI().toString());
                deploymentManager.addDeployable((Deployable)((FileConfiguration)this.configuration));
                deploymentManager.addDeployable((Deployable)((FileJMSConfiguration)this.jmsFileConfiguration));
                this.securityConfiguration = new FileSecurityConfiguration(new File(this.configurationDir, "artemis-users.properties").toURI().toString(), new File(this.configurationDir, "artemis-roles.properties").toURI().toString(), "guest", Boolean.valueOf(false), null);
                ((FileSecurityConfiguration)this.securityConfiguration).start();
                deploymentManager.readConfiguration();
            } else {
                this.configuration = new ConfigurationImpl();
                this.configuration.setJournalType(JournalType.NIO);
                this.jmsFileConfiguration = new JMSConfigurationImpl();
                this.securityConfiguration = new SecurityConfiguration();
            }
            this.createServer(this.configuration, this.jmsFileConfiguration);
            if (this.waitOnStart.booleanValue()) {
                dirName = System.getProperty("activemq.config.dir", ".");
                File file = new File(dirName + "/STOP_ME");
                if (file.exists()) {
                    file.delete();
                }
                while (!file.exists()) {
                    Thread.sleep(500L);
                }
                this.manager.stop();
                file.delete();
            } else {
                File restartFile;
                File killFile;
                dirName = this.configurationDir != null ? this.configurationDir : ".";
                File stopFile = new File(dirName + "/STOP_ME");
                if (stopFile.exists()) {
                    stopFile.delete();
                }
                if ((killFile = new File(dirName + "/KILL_ME")).exists()) {
                    killFile.delete();
                }
                if ((restartFile = new File(dirName + "/RESTART_ME")).exists()) {
                    restartFile.delete();
                }
                Timer timer = new Timer("ActiveMQ Artemis Server Shutdown Timer", false);
                timer.scheduleAtFixedRate((TimerTask)new ServerStopTimerTask(stopFile, killFile, restartFile, timer), 500L, 500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private void createServer(Configuration configuration, JMSConfiguration jmsFileConfiguration) throws Exception {
        if (this.nodeId != null && !this.nodeId.equals("") && !this.nodeId.equals("null")) {
            InVMNodeManager nodeManager = (InVMNodeManager)managerMap.get(this.nodeId);
            if (nodeManager == null) {
                boolean replicatedBackup = configuration.getHAPolicyConfiguration().getType() == HAPolicyConfiguration.TYPE.REPLICA;
                nodeManager = new InVMNodeManager(replicatedBackup, configuration.getJournalDirectory());
                managerMap.put(this.nodeId, (NodeManager)nodeManager);
            }
            this.server = new InVMNodeManagerServer(configuration, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)(this.securityManager != null ? this.securityManager : new ActiveMQSecurityManagerImpl(this.securityConfiguration)), (NodeManager)nodeManager);
        } else {
            this.server = new ActiveMQServerImpl(configuration, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)(this.securityManager != null ? this.securityManager : new ActiveMQSecurityManagerImpl(this.securityConfiguration)));
        }
        this.manager = new JMSServerManagerImpl(this.server, jmsFileConfiguration);
        this.manager.start();
    }

    private class ServerStopTimerTask
    extends TimerTask {
        private final File stopFile;
        private final Timer timer;
        private final File killFile;
        private final File restartFile;

        public ServerStopTimerTask(File stopFile, File killFile, File restartFile, Timer timer) {
            this.stopFile = stopFile;
            this.killFile = killFile;
            this.restartFile = restartFile;
            this.timer = timer;
        }

        @Override
        public void run() {
            if (this.stopFile.exists()) {
                try {
                    this.timer.cancel();
                }
                finally {
                    try {
                        if (ActiveMQBootstrap.this.manager != null) {
                            ActiveMQBootstrap.this.manager.stop();
                            ActiveMQBootstrap.this.manager = null;
                        }
                        ActiveMQBootstrap.this.server = null;
                        this.stopFile.delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ActiveMQBootstrap.this.spawned) {
                    Runtime.getRuntime().halt(666);
                }
            } else if (this.killFile.exists()) {
                try {
                    ActiveMQBootstrap.this.manager.getActiveMQServer().stop(true);
                    ActiveMQBootstrap.this.manager.stop();
                    ActiveMQBootstrap.this.manager = null;
                    ActiveMQBootstrap.this.server = null;
                    this.killFile.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.restartFile.exists()) {
                try {
                    ActiveMQBootstrap.this.createServer(ActiveMQBootstrap.this.configuration, ActiveMQBootstrap.this.jmsFileConfiguration);
                    this.restartFile.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

