/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.cli.commands.Configurable;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class ArtemisAbstractPlugin
extends AbstractMojo {
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}")
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    protected List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isIgnore()) {
            this.getLog().debug((CharSequence)"******************************************************************************************************");
            this.getLog().debug((CharSequence)("Execution of " + ((Object)((Object)this)).getClass().getSimpleName() + " is being ignored as ignore has been set to true"));
            this.getLog().debug((CharSequence)"******************************************************************************************************");
        } else {
            this.doExecute();
            Configurable.unlock();
        }
    }

    protected abstract boolean isIgnore();

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected Artifact newArtifact(String artifactID) throws MojoFailureException {
        DefaultArtifact artifact;
        try {
            artifact = new DefaultArtifact(artifactID);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        return artifact;
    }

    protected File resolveArtifact(Artifact artifact) throws MojoExecutionException, DependencyCollectionException {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(artifact);
        request.setRepositories(this.remoteRepos);
        try {
            result = this.repositorySystem.resolveArtifact(this.repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return result.getArtifact().getFile();
    }

    protected List<Artifact> explodeDependencies(Artifact artifact) throws DependencyCollectionException {
        final LinkedList<Artifact> dependencies = new LinkedList<Artifact>();
        CollectRequest exploreDependenciesRequest = new CollectRequest(new Dependency(artifact, "compile"), this.remoteRepos);
        CollectResult result = this.repositorySystem.collectDependencies(this.repoSession, exploreDependenciesRequest);
        final AtomicInteger level = new AtomicInteger(0);
        DependencyNode node = result.getRoot();
        StringWriter writer = new StringWriter();
        final PrintWriter strPrint = new PrintWriter(writer);
        strPrint.println("Dependencies explored for " + artifact + ":");
        if (node != null) {
            node.accept(new DependencyVisitor(){

                public boolean visitEnter(DependencyNode node) {
                    for (int i = 0; i < level.get(); ++i) {
                        strPrint.print("!...");
                    }
                    level.incrementAndGet();
                    strPrint.println("Dependency:: " + node.getDependency() + " node = " + node.getArtifact());
                    dependencies.add(node.getArtifact());
                    return true;
                }

                public boolean visitLeave(DependencyNode node) {
                    level.decrementAndGet();
                    return true;
                }
            });
        }
        this.getLog().info((CharSequence)writer.toString());
        return dependencies;
    }

    protected Set<File> resolveDependencies(String[] dependencyListParameter, String[] individualListParameter) throws DependencyCollectionException, MojoFailureException, MojoExecutionException {
        HashSet<File> filesSet = new HashSet<File>();
        if (dependencyListParameter != null) {
            for (String lib : dependencyListParameter) {
                this.getLog().debug((CharSequence)("********************" + lib));
                List<Artifact> artifactsList = this.explodeDependencies(this.newArtifact(lib));
                for (Artifact artifact : artifactsList) {
                    File artifactFile = this.resolveArtifact(artifact);
                    filesSet.add(artifactFile);
                }
            }
        }
        if (individualListParameter != null) {
            for (String lib : individualListParameter) {
                Artifact artifact = this.newArtifact(lib);
                this.getLog().debug((CharSequence)("Single dpendency resolved::" + artifact));
                File artifactFile = this.resolveArtifact(artifact);
                filesSet.add(artifactFile);
            }
        }
        return filesSet;
    }
}

