/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.boot.Artemis;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.activemq.artemis.utils.FileUtil;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="create", defaultPhase=LifecyclePhase.VERIFY)
public class ArtemisCreatePlugin
extends ArtemisAbstractPlugin {
    @Parameter
    String name;
    private PluginDescriptor descriptor;
    @Parameter(defaultValue="${basedir}/target/classes/activemq/server0", required=true)
    private File configuration;
    @Parameter(defaultValue="${activemq.basedir}", required=true)
    private File home;
    @Parameter(defaultValue="${activemq.basedir}/artemis-distribution/target/apache-artemis-${project.version}-bin/apache-artemis-${project.version}/", required=true)
    private File alternateHome;
    @Parameter(defaultValue="${basedir}/target/server0", required=true)
    private File instance;
    @Parameter(defaultValue="true")
    private boolean noWeb;
    @Parameter(defaultValue="guest")
    private String user;
    @Parameter(defaultValue="guest")
    private String password;
    @Parameter(defaultValue="guest")
    private String role;
    @Parameter(defaultValue="")
    private String javaOptions = "";
    @Parameter(defaultValue="0")
    private int portOffset = 0;
    @Parameter(defaultValue="true")
    private boolean allowAnonymous;
    @Parameter(defaultValue="false")
    private boolean replicated;
    @Parameter(defaultValue="false")
    private boolean sharedStore;
    @Parameter(defaultValue="false")
    private boolean clustered;
    @Parameter(defaultValue="false")
    private boolean slave;
    @Parameter(defaultValue="./data")
    String dataFolder;
    @Parameter(defaultValue="false")
    private boolean failoverOnShutdown;
    @Parameter(defaultValue="true")
    private boolean noAutoTune;
    @Parameter(defaultValue="ON_DEMAND")
    private String messageLoadBalancing;
    @Parameter
    ArrayList<String> args = new ArrayList();
    @Parameter
    private String[] libList;
    @Parameter
    private String[] libListWithDeps;
    @Parameter(defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${noServer}")
    boolean ignore;

    private boolean lookupHome(Path path) {
        if (path == null) {
            return false;
        }
        Path binFolder = path.resolve("bin");
        if (binFolder == null && Files.exists(binFolder, LinkOption.NOFOLLOW_LINKS)) {
            return false;
        }
        Path artemisScript = binFolder.resolve("artemis");
        return artemisScript != null && Files.exists(artemisScript, LinkOption.NOFOLLOW_LINKS);
    }

    private void add(List<String> list, String ... str) {
        for (String s : str) {
            list.add(s);
        }
    }

    @Override
    protected boolean isIgnore() {
        return this.ignore;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        FileOutputStream outputStream;
        this.getLog().info((CharSequence)("Local " + this.localRepository));
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        if (!this.lookupHome(this.home.toPath())) {
            if (this.lookupHome(this.alternateHome.toPath())) {
                this.home = this.alternateHome;
            } else {
                this.getLog().error((CharSequence)"********************************************************************************************");
                this.getLog().error((CharSequence)("Could not locate suitable Artemis.home on either " + this.home + " or " + this.alternateHome));
                this.getLog().error((CharSequence)"Use the binary distribution or build the distribution before running the examples");
                this.getLog().error((CharSequence)"********************************************************************************************");
                throw new MojoExecutionException("Couldn't find artemis.home");
            }
        }
        Map properties = this.getPluginContext();
        Set entries = properties.entrySet();
        this.getLog().info((CharSequence)("Entries.size " + entries.size()));
        for (Map.Entry entry : entries) {
            this.getLog().info((CharSequence)("... key=" + entry.getKey() + " = " + entry.getValue()));
        }
        ArrayList<String> listCommands = new ArrayList<String>();
        this.add(listCommands, "create", "--allow-anonymous", "--silent", "--force", "--no-web", "--user", this.user, "--password", this.password, "--role", this.role, "--port-offset", "" + this.portOffset, "--data", this.dataFolder);
        if (this.allowAnonymous) {
            this.add(listCommands, "--allow-anonymous");
        } else {
            this.add(listCommands, "--require-login");
        }
        if (!this.javaOptions.isEmpty()) {
            this.add(listCommands, "--java-options", this.javaOptions);
        }
        if (this.slave) {
            this.add(listCommands, "--slave");
        }
        if (this.replicated) {
            this.add(listCommands, "--replicated");
        }
        if (this.sharedStore) {
            this.add(listCommands, "--shared-store");
        }
        if (this.clustered) {
            this.add(listCommands, "--clustered");
            this.add(listCommands, "--message-load-balancing", this.messageLoadBalancing);
        }
        if (this.failoverOnShutdown) {
            this.add(listCommands, "--failover-on-shutdown");
        }
        if (this.noAutoTune) {
            this.add(listCommands, "--no-autotune");
        }
        this.add(listCommands, "--verbose");
        if ("Linux".equals(System.getProperty("os.name"))) {
            this.add(listCommands, "--aio");
        }
        for (String str : this.args) {
            this.add(listCommands, str);
        }
        this.add(listCommands, this.instance.getAbsolutePath());
        this.getLog().debug((CharSequence)("***** Server created at " + this.instance + " with home=" + this.home + " *****"));
        File file = new File(this.instance.getParentFile(), "create-" + this.instance.getName() + ".sh");
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
        PrintStream commandLineStream = new PrintStream(outputStream);
        commandLineStream.println("# These are the commands used to create " + this.instance.getName());
        commandLineStream.println(this.getCommandline(listCommands));
        try {
            Set<File> files;
            String[] list;
            Artemis.execute((File)this.home, null, listCommands);
            if (this.configuration != null && (list = this.configuration.list()) != null) {
                this.getLog().debug((CharSequence)"************************************************");
                this.getLog().debug((CharSequence)"Copying configuration files:");
                this.copyConfigurationFiles(list, this.configuration.toPath(), this.instance.toPath().resolve("etc"), commandLineStream);
            }
            if (!(files = this.resolveDependencies(this.libListWithDeps, this.libList)).isEmpty()) {
                commandLineStream.println();
                commandLineStream.println("# This is a list of files that need to be installed under ./lib.");
                commandLineStream.println("# We are copying them from your maven lib home");
                for (File file2 : files) {
                    this.copyToLib(file2, commandLineStream);
                }
            }
            commandLineStream.close();
            FileUtil.makeExec((File)file);
            this.getLog().info((CharSequence)"###################################################################################################");
            this.getLog().info((CharSequence)(file.getName() + " created with commands to reproduce " + this.instance.getName()));
            this.getLog().info((CharSequence)("under " + file.getParent()));
            this.getLog().info((CharSequence)"###################################################################################################");
        }
        catch (Throwable e) {
            this.getLog().error(e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    private void copyConfigurationFiles(String[] list, Path sourcePath, Path targetPath, PrintStream commandLineStream) throws IOException {
        for (String file : list) {
            Path target = targetPath.resolve(file);
            Path originalFile = sourcePath.resolve(file);
            Files.copy(originalFile, target, StandardCopyOption.REPLACE_EXISTING);
            commandLineStream.println("");
            if (originalFile.toFile().isDirectory()) {
                this.getLog().debug((CharSequence)("Creating directory " + target));
                commandLineStream.println("# creating directory " + originalFile.getFileName());
                commandLineStream.println("mkdir " + target);
                this.copyConfigurationFiles(originalFile.toFile().list(), originalFile, target, commandLineStream);
                continue;
            }
            this.getLog().debug((CharSequence)("Copying " + file + " to " + target));
            commandLineStream.println("# copying config file " + originalFile.getFileName());
            commandLineStream.println("cp " + originalFile + " " + target);
        }
    }

    private String getCommandline(ArrayList<String> listCommands) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.home.getAbsolutePath() + "/bin/artemis ");
        for (String string : listCommands) {
            buffer.append(string + " ");
        }
        return buffer.toString();
    }

    private void copyToLib(File projectLib, PrintStream commandLineStream) throws IOException {
        Path target = this.instance.toPath().resolve("lib").resolve(projectLib.getName());
        File file = target.toFile();
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
            commandLineStream.println("mkdir " + file.getParent());
        }
        commandLineStream.println("cp " + projectLib.getAbsolutePath() + " " + target);
        this.getLog().debug((CharSequence)("Copying " + projectLib.getName() + " as " + target.toFile().getAbsolutePath()));
        Files.copy(projectLib.toPath(), target, StandardCopyOption.REPLACE_EXISTING);
    }
}

