/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.activemq.artemis.boot.Artemis;
import org.apache.activemq.artemis.cli.commands.Run;
import org.apache.activemq.artemis.cli.process.ProcessBuilder;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="cli", defaultPhase=LifecyclePhase.VERIFY)
public class ArtemisCLIPlugin
extends ArtemisAbstractPlugin {
    private PluginDescriptor descriptor;
    @Parameter(defaultValue="${noServer}")
    boolean ignore;
    @Parameter(defaultValue="server")
    String name;
    @Parameter(defaultValue="${activemq.basedir}", required=true)
    private File home;
    @Parameter(defaultValue="${activemq.basedir}/artemis-distribution/target/apache-artemis-${project.version}-bin/apache-artemis-${project.version}/", required=true)
    private File alternateHome;
    @Parameter(defaultValue="${basedir}/target/server0", required=true)
    private File location;
    @Parameter
    private String[] args;
    @Parameter
    private boolean spawn = false;
    @Parameter(defaultValue="300000")
    private long spawnTimeout;
    @Parameter
    private String testURI = null;
    @Parameter
    private String testUser = null;
    @Parameter
    private String testPassword = null;

    private boolean lookupHome(Path path) {
        if (path == null) {
            return false;
        }
        Path binFolder = path.resolve("bin");
        if (binFolder == null && Files.exists(binFolder, LinkOption.NOFOLLOW_LINKS)) {
            return false;
        }
        Path artemisScript = binFolder.resolve("artemis");
        return artemisScript != null && Files.exists(artemisScript, LinkOption.NOFOLLOW_LINKS);
    }

    @Override
    protected boolean isIgnore() {
        return this.ignore;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Run.setEmbedded((boolean)true);
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        if (!this.lookupHome(this.home.toPath())) {
            if (this.lookupHome(this.alternateHome.toPath())) {
                this.home = this.alternateHome;
            } else {
                this.getLog().error((CharSequence)"********************************************************************************************");
                this.getLog().error((CharSequence)("Could not locate suitable Artemis.home on either " + this.home + " or " + this.alternateHome));
                this.getLog().error((CharSequence)"Use the binary distribution or build the distribution before running the examples");
                this.getLog().error((CharSequence)"********************************************************************************************");
                throw new MojoExecutionException("Couldn't find artemis.home");
            }
        }
        try {
            if (this.spawn) {
                final Process process = ProcessBuilder.build((String)this.name, (File)this.location, (boolean)true, (String[])this.args);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        process.destroy();
                    }
                });
                if (this.testURI != null) {
                    long timeout = System.currentTimeMillis() + this.spawnTimeout;
                    while (System.currentTimeMillis() <= timeout) {
                        try (ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.testURI);){
                            if (this.testUser != null && this.testPassword != null) {
                                cf.createConnection(this.testUser, this.testPassword).close();
                            } else {
                                cf.createConnection().close();
                            }
                            this.getLog().info((CharSequence)"Server started");
                            break;
                        }
                        catch (Exception e) {
                            this.getLog().info((CharSequence)"awaiting server to start");
                            Thread.sleep(500L);
                        }
                    }
                }
            } else {
                Artemis.execute((File)this.home, (File)this.location, (String[])this.args);
            }
            Thread.sleep(600L);
            ProcessBuilder.cleanupProcess();
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

