/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="dependency-doc", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class ArtemisDependencyDocPlugin
extends ArtemisAbstractPlugin {
    @Parameter
    String name;
    @Parameter
    private String[] groupOrder;
    @Parameter(defaultValue="https://repo.maven.apache.org/maven2")
    private String defaultRepo = "https://repo.maven.apache.org/maven2";
    @Parameter
    private String header;
    @Parameter
    private String lib;
    @Parameter
    private String line;
    @Parameter
    private String footer;
    @Parameter
    private String[] detailKey;
    @Parameter
    String[] detailValue;
    @Parameter
    private String[] extraRepositories;
    @Parameter
    private String file;
    private MavenProject project;

    @Override
    protected boolean isIgnore() {
        return false;
    }

    private String applyFilters(String content, Map<String, String> filters) throws IOException {
        if (filters != null) {
            for (Map.Entry<String, String> entry : filters.entrySet()) {
                try {
                    content = this.replace(content, entry.getKey(), entry.getValue());
                }
                catch (Throwable e) {
                    System.out.println("Error on " + entry.getKey());
                    e.printStackTrace();
                }
            }
        }
        return content;
    }

    private String replace(String content, String key, String value) {
        return content.replaceAll(Pattern.quote(key), Matcher.quoteReplacement(value));
    }

    private String getPackageName(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + (String)(artifact.getClassifier() != null && !artifact.getClassifier().equals("") ? ":" + artifact.getClassifier() : "");
    }

    private String getGroupOrder(String group) {
        int i;
        if (this.groupOrder == null) {
            this.groupOrder = new String[]{"org.apache.activemq"};
        }
        for (i = 0; i < this.groupOrder.length; ++i) {
            if (!group.equals(this.groupOrder[i])) continue;
            return Integer.toString(i);
        }
        return Integer.toString(i);
    }

    @Override
    protected void doExecute() {
        HashMap<String, String> keys = new HashMap<String, String>();
        if (this.detailKey != null) {
            if (this.detailValue == null) {
                throw new IllegalStateException("you need to specify all detail parameters");
            }
            if (this.detailKey.length != this.detailValue.length) {
                throw new IllegalStateException("Illegal argument size");
            }
            for (int i = 0; i < this.detailKey.length; ++i) {
                keys.put(this.detailKey[i], this.detailValue[i]);
            }
        }
        if (this.file == null) {
            throw new IllegalStateException("you must specify the file output");
        }
        if (this.line == null) {
            throw new IllegalStateException("you must specify the line");
        }
        try {
            File javaFile = new File(this.file);
            javaFile.getParentFile().mkdirs();
            PrintStream stream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.file)));
            if (this.header != null) {
                stream.println(this.header);
            }
            List<Artifact> artifacts = this.explodeDependencies(this.newArtifact(this.lib));
            Collections.sort(artifacts, (o1, o2) -> {
                String pref1 = this.getGroupOrder(o1.getGroupId());
                String pref2 = this.getGroupOrder(o2.getGroupId());
                return (pref1 + o1.getGroupId() + o1.getArtifactId()).compareTo(pref2 + o2.getGroupId() + o2.getArtifactId());
            });
            artifacts.forEach(art -> {
                try {
                    String detail = (String)keys.get(art.getGroupId() + ":" + art.getArtifactId());
                    if (detail == null) {
                        detail = "";
                    }
                    ArtifactResult result = this.resolveArtifact((Artifact)art);
                    HashMap<String, String> filter = new HashMap<String, String>();
                    filter.put("X{detail}", detail);
                    filter.put("X{group}", art.getGroupId());
                    filter.put("X{artifact}", art.getArtifactId());
                    filter.put("X{classifier}", result.getArtifact().getClassifier());
                    filter.put("X{package}", this.getPackageName(result.getArtifact()));
                    filter.put("X{file}", result.getArtifact().getFile().getName());
                    filter.put("X{version}", result.getArtifact().getVersion());
                    String uri = this.getURI(result);
                    filter.put("X{uri}", uri);
                    if (uri.equals("")) {
                        filter.put("X{fileMD}", result.getArtifact().getFile().getName());
                    } else {
                        filter.put("X{fileMD}", "link:" + uri + "[" + result.getArtifact().getFile().getName() + "]");
                    }
                    String output = this.applyFilters(this.line, filter);
                    if (this.getLog().isDebugEnabled()) {
                        filter.forEach((a, b) -> this.getLog().debug((CharSequence)("filter.put(" + a + ", " + b + ")")));
                        this.getLog().debug((CharSequence)output);
                    }
                    stream.println(output);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
            if (this.footer != null) {
                stream.println(this.footer);
            }
            stream.close();
        }
        catch (Throwable e) {
            this.getLog().error((CharSequence)e.getMessage(), e);
        }
    }

    private String getURI(ArtifactResult result) {
        Artifact art = result.getArtifact();
        String uri = "";
        if (result.getRepository() instanceof RemoteRepository) {
            RemoteRepository remoteRepository = (RemoteRepository)result.getRepository();
            uri = remoteRepository.getUrl();
        } else {
            uri = this.defaultRepo;
        }
        return uri + "/" + art.getGroupId().replace('.', '/') + "/" + art.getArtifactId() + "/" + art.getVersion();
    }
}

