/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;

public class MQTTConnection
implements RemotingConnection {
    private final Connection transportConnection;
    private final long creationTime;
    private AtomicBoolean dataReceived;
    private boolean destroyed;
    private boolean connected;
    private final List<FailureListener> failureListeners = Collections.synchronizedList(new ArrayList());
    private final List<CloseListener> closeListeners = Collections.synchronizedList(new ArrayList());

    public MQTTConnection(Connection transportConnection) throws Exception {
        this.transportConnection = transportConnection;
        this.creationTime = System.currentTimeMillis();
        this.dataReceived = new AtomicBoolean();
        this.destroyed = false;
    }

    public Object getID() {
        return this.transportConnection.getID();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    public void addFailureListener(FailureListener listener) {
        this.failureListeners.add(listener);
    }

    public boolean removeFailureListener(FailureListener listener) {
        return this.failureListeners.remove(listener);
    }

    public void addCloseListener(CloseListener listener) {
        this.closeListeners.add(listener);
    }

    public boolean removeCloseListener(CloseListener listener) {
        return this.closeListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CloseListener> removeCloseListeners() {
        List<CloseListener> list = this.closeListeners;
        synchronized (list) {
            ArrayList<CloseListener> deletedCloseListeners = new ArrayList<CloseListener>(this.closeListeners);
            this.closeListeners.clear();
            return deletedCloseListeners;
        }
    }

    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.addAll(listeners);
    }

    public List<FailureListener> getFailureListeners() {
        return this.failureListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FailureListener> removeFailureListeners() {
        List<FailureListener> list = this.failureListeners;
        synchronized (list) {
            ArrayList<FailureListener> deletedFailureListeners = new ArrayList<FailureListener>(this.failureListeners);
            this.failureListeners.clear();
            return deletedFailureListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailureListeners(List<FailureListener> listeners) {
        List<FailureListener> list = this.failureListeners;
        synchronized (list) {
            this.failureListeners.clear();
            this.failureListeners.addAll(listeners);
        }
    }

    public ActiveMQBuffer createTransportBuffer(int size) {
        return this.transportConnection.createTransportBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(ActiveMQException me) {
        List<FailureListener> list = this.failureListeners;
        synchronized (list) {
            for (FailureListener listener : this.failureListeners) {
                listener.connectionFailed(me, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(ActiveMQException me, String scaleDownTargetNodeID) {
        List<FailureListener> list = this.failureListeners;
        synchronized (list) {
            for (FailureListener listener : this.failureListeners) {
                listener.connectionFailed(me, false);
            }
        }
    }

    public void destroy() {
        this.destroyed = true;
        this.disconnect(false);
    }

    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void disconnect(boolean criticalError) {
        this.transportConnection.forceClose();
    }

    public void disconnect(String scaleDownNodeID, boolean criticalError) {
        this.transportConnection.forceClose();
    }

    protected void dataReceived() {
        this.dataReceived.set(true);
    }

    public boolean checkDataReceived() {
        return this.dataReceived.compareAndSet(true, false);
    }

    public void flush() {
        this.transportConnection.checkFlushBatchBuffer();
    }

    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean getConnected() {
        return this.connected;
    }
}

