/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolHandler;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManagerFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.MessageConverter;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;

class MQTTProtocolManager
implements ProtocolManager,
NotificationListener {
    private ActiveMQServer server;
    private MQTTLogger log = MQTTLogger.LOGGER;

    public MQTTProtocolManager(ActiveMQServer server) {
        this.server = server;
    }

    public void onNotification(Notification notification) {
    }

    public ProtocolManagerFactory getFactory() {
        return new MQTTProtocolManagerFactory();
    }

    public void updateInterceptors(List incomingInterceptors, List outgoingInterceptors) {
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        try {
            MQTTConnection mqttConnection = new MQTTConnection(connection);
            ConnectionEntry entry = new ConnectionEntry((RemotingConnection)mqttConnection, null, System.currentTimeMillis(), 5000L);
            NettyServerConnection nettyConnection = (NettyServerConnection)connection;
            MQTTProtocolHandler protocolHandler = (MQTTProtocolHandler)nettyConnection.getChannel().pipeline().get(MQTTProtocolHandler.class);
            protocolHandler.setConnection(mqttConnection, entry);
            return entry;
        }
        catch (Exception e) {
            this.log.error(e);
            return null;
        }
    }

    public void removeHandler(String name) {
    }

    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
        connection.bufferReceived(connection.getID(), buffer);
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new MqttEncoder()});
        pipeline.addLast(new ChannelHandler[]{new MqttDecoder(0xFFFFFFF)});
        pipeline.addLast(new ChannelHandler[]{new MQTTProtocolHandler(this.server)});
    }

    public boolean isProtocol(byte[] array) {
        boolean mqtt311 = array[4] == 77 && array[5] == 81 && array[6] == 84 && array[7] == 84;
        boolean mqtt31 = array[4] == 77 && array[5] == 81 && array[6] == 73 && array[7] == 115;
        return mqtt311 || mqtt31;
    }

    public MessageConverter getConverter() {
        return null;
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
    }
}

