/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTFailureListener;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class MQTTConnectionManager {
    private MQTTSession session;
    public static Set<String> CONNECTED_CLIENTS = new ConcurrentHashSet();
    private MQTTLogger log = MQTTLogger.LOGGER;

    public MQTTConnectionManager(MQTTSession session) {
        this.session = session;
        MQTTFailureListener failureListener = new MQTTFailureListener(this);
        session.getConnection().addFailureListener(failureListener);
    }

    synchronized void connect(String cId, String username, String password, boolean will, String willMessage, String willTopic, boolean willRetain, int willQosLevel, boolean cleanSession) throws Exception {
        String clientId = this.validateClientId(cId, cleanSession);
        if (clientId == null) {
            this.session.getProtocolHandler().sendConnack(MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
            this.session.getProtocolHandler().disconnect();
            return;
        }
        this.session.setSessionState(this.getSessionState(clientId));
        ServerSessionImpl serverSession = this.createServerSession(username, password);
        serverSession.start();
        this.session.setServerSession(serverSession);
        this.session.setIsClean(cleanSession);
        if (will) {
            ServerMessage w = MQTTUtil.createServerMessageFromString(this.session, willMessage, willTopic, willQosLevel, willRetain);
            this.session.getSessionState().setWillMessage(w);
        }
        this.session.getConnection().setConnected(true);
        this.session.start();
        this.session.getProtocolHandler().sendConnack(MqttConnectReturnCode.CONNECTION_ACCEPTED);
    }

    ServerSessionImpl createServerSession(String username, String password) throws Exception {
        String id = UUIDGenerator.getInstance().generateStringUUID();
        ActiveMQServer server = this.session.getServer();
        ServerSession serverSession = server.createSession(id, username, password, 102400, (RemotingConnection)this.session.getConnection(), true, true, false, false, null, this.session.getSessionCallback(), false, server.newOperationContext());
        return (ServerSessionImpl)serverSession;
    }

    void disconnect() {
        if (this.session == null) {
            return;
        }
        try {
            if (this.session.getSessionState() != null) {
                String clientId = this.session.getSessionState().getClientId();
                if (clientId != null) {
                    CONNECTED_CLIENTS.remove(clientId);
                }
                if (this.session.getState().isWill()) {
                    this.session.getConnectionManager().sendWill();
                }
            }
            this.session.stop();
            this.session.getConnection().disconnect(false);
            this.session.getConnection().destroy();
        }
        catch (Exception e) {
            this.log.error("Error disconnecting client: " + e.getMessage());
        }
    }

    private void sendWill() throws Exception {
        this.session.getServerSession().send(this.session.getSessionState().getWillMessage(), true);
        this.session.getSessionState().deleteWillMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MQTTSessionState getSessionState(String clientId) throws InterruptedException {
        Map<String, MQTTSessionState> map = MQTTSession.SESSIONS;
        synchronized (map) {
            MQTTSessionState state = MQTTSession.SESSIONS.get(clientId);
            if (state != null) {
                while (state.getAttached()) {
                    Thread.sleep(1000L);
                }
                return state;
            }
            state = new MQTTSessionState(clientId);
            MQTTSession.SESSIONS.put(clientId, state);
            return state;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String validateClientId(String clientId, boolean cleanSession) {
        if (clientId == null || clientId.isEmpty()) {
            if (!cleanSession) return null;
            return UUID.randomUUID().toString();
        }
        if (CONNECTED_CLIENTS.add(clientId)) return clientId;
        return null;
    }
}

