/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolHandler;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManagerFactory;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.spi.core.protocol.AbstractProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.collections.TypedProperties;

public class MQTTProtocolManager
extends AbstractProtocolManager<MqttMessage, MQTTInterceptor, MQTTConnection>
implements NotificationListener {
    private static final List<String> websocketRegistryNames = Arrays.asList("mqtt", "mqttv3.1");
    private ActiveMQServer server;
    private MQTTLogger log = MQTTLogger.LOGGER;
    private final List<MQTTInterceptor> incomingInterceptors = new ArrayList<MQTTInterceptor>();
    private final List<MQTTInterceptor> outgoingInterceptors = new ArrayList<MQTTInterceptor>();
    private final Map<String, MQTTConnection> connectedClients;
    private final Map<String, MQTTSessionState> sessionStates;

    MQTTProtocolManager(ActiveMQServer server, Map<String, MQTTConnection> connectedClients, Map<String, MQTTSessionState> sessionStates, List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) {
        this.server = server;
        this.connectedClients = connectedClients;
        this.sessionStates = sessionStates;
        this.updateInterceptors(incomingInterceptors, outgoingInterceptors);
        server.getManagementService().addNotificationListener((NotificationListener)this);
    }

    public void onNotification(Notification notification) {
        String clientId;
        MQTTConnection mqttConnection;
        if (!(notification.getType() instanceof CoreNotificationType)) {
            return;
        }
        CoreNotificationType type = (CoreNotificationType)notification.getType();
        if (type != CoreNotificationType.SESSION_CREATED) {
            return;
        }
        TypedProperties props = notification.getProperties();
        SimpleString protocolName = props.getSimpleStringProperty(ManagementHelper.HDR_PROTOCOL_NAME);
        if (protocolName == null || !protocolName.toString().equals("MQTT")) {
            return;
        }
        int distance = props.getIntProperty(ManagementHelper.HDR_DISTANCE);
        if (distance > 0 && (mqttConnection = this.connectedClients.get(clientId = props.getSimpleStringProperty(ManagementHelper.HDR_CLIENT_ID).toString())) != null) {
            mqttConnection.destroy();
        }
    }

    public ProtocolManagerFactory getFactory() {
        return new MQTTProtocolManagerFactory();
    }

    public void updateInterceptors(List incoming, List outgoing) {
        this.incomingInterceptors.clear();
        this.incomingInterceptors.addAll(this.getFactory().filterInterceptors(incoming));
        this.outgoingInterceptors.clear();
        this.outgoingInterceptors.addAll(this.getFactory().filterInterceptors(outgoing));
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        try {
            MQTTConnection mqttConnection = new MQTTConnection(connection);
            ConnectionEntry entry = new ConnectionEntry((RemotingConnection)mqttConnection, null, System.currentTimeMillis(), 5000L);
            NettyServerConnection nettyConnection = (NettyServerConnection)connection;
            MQTTProtocolHandler protocolHandler = (MQTTProtocolHandler)nettyConnection.getChannel().pipeline().get(MQTTProtocolHandler.class);
            protocolHandler.setConnection(mqttConnection, entry);
            return entry;
        }
        catch (Exception e) {
            this.log.error(e);
            return null;
        }
    }

    public boolean acceptsNoHandshake() {
        return false;
    }

    public void removeHandler(String name) {
    }

    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
        connection.bufferReceived(connection.getID(), buffer);
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{MqttEncoder.INSTANCE});
        pipeline.addLast(new ChannelHandler[]{new MqttDecoder(0xFFFFFFF)});
        pipeline.addLast(new ChannelHandler[]{new MQTTProtocolHandler(this.server, this)});
    }

    public boolean isProtocol(byte[] array) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])array);
        if (buf.readByte() != 16 || !this.validateRemainingLength(buf) || buf.readByte() != 0) {
            return false;
        }
        byte b = buf.readByte();
        return (b == 4 || b == 6) && buf.readByte() == 77;
    }

    private boolean validateRemainingLength(ByteBuf buffer) {
        int msb = -128;
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            if ((buffer.readByte() & msb) == msb) continue;
            return true;
        }
        return false;
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
    }

    public List<String> websocketSubprotocolIdentifiers() {
        return websocketRegistryNames;
    }

    public void invokeIncoming(MqttMessage mqttMessage, MQTTConnection connection) {
        super.invokeInterceptors(this.incomingInterceptors, (Object)mqttMessage, (RemotingConnection)connection);
    }

    public void invokeOutgoing(MqttMessage mqttMessage, MQTTConnection connection) {
        super.invokeInterceptors(this.outgoingInterceptors, (Object)mqttMessage, (RemotingConnection)connection);
    }

    public boolean isClientConnected(String clientId, MQTTConnection connection) {
        MQTTConnection connectedConn = this.connectedClients.get(clientId);
        if (connectedConn != null) {
            return connectedConn.equals(connection);
        }
        return false;
    }

    public void removeConnectedClient(String clientId) {
        this.connectedClients.remove(clientId);
    }

    public MQTTConnection addConnectedClient(String clientId, MQTTConnection connection) {
        return this.connectedClients.put(clientId, connection);
    }

    public MQTTSessionState getSessionState(String clientId) {
        return this.sessionStates.computeIfAbsent(clientId, MQTTSessionState::new);
    }

    public MQTTSessionState removeSessionState(String clientId) {
        return this.sessionStates.remove(clientId);
    }

    public Map<String, MQTTSessionState> getSessionStates() {
        return new HashMap<String, MQTTSessionState>(this.sessionStates);
    }

    public Map<String, MQTTConnection> getConnectedClients() {
        return this.connectedClients;
    }
}

