/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTMessageInfo;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;

public class MQTTSessionState {
    public static final MQTTSessionState DEFAULT = new MQTTSessionState(null);
    private String clientId;
    private final ConcurrentMap<String, MqttTopicSubscription> subscriptions = new ConcurrentHashMap<String, MqttTopicSubscription>();
    private final Map<Integer, MQTTMessageInfo> messageRefStore = new ConcurrentHashMap<Integer, MQTTMessageInfo>();
    private final ConcurrentMap<String, Map<Long, Integer>> addressMessageMap = new ConcurrentHashMap<String, Map<Long, Integer>>();
    private final Set<Integer> pubRec = new HashSet<Integer>();
    private boolean attached = false;
    private final OutboundStore outboundStore = new OutboundStore();

    public MQTTSessionState(String clientId) {
        this.clientId = clientId;
    }

    public synchronized void clear() {
        this.subscriptions.clear();
        this.messageRefStore.clear();
        this.addressMessageMap.clear();
        this.pubRec.clear();
        this.outboundStore.clear();
    }

    OutboundStore getOutboundStore() {
        return this.outboundStore;
    }

    Set<Integer> getPubRec() {
        return this.pubRec;
    }

    boolean getAttached() {
        return this.attached;
    }

    void setAttached(boolean attached) {
        this.attached = attached;
    }

    Collection<MqttTopicSubscription> getSubscriptions() {
        return this.subscriptions.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addSubscription(MqttTopicSubscription subscription, WildcardConfiguration wildcardConfiguration) {
        ConcurrentMap<String, MqttTopicSubscription> concurrentMap = this.subscriptions;
        synchronized (concurrentMap) {
            this.addressMessageMap.putIfAbsent(MQTTUtil.convertMQTTAddressFilterToCore(subscription.topicName(), wildcardConfiguration), new ConcurrentHashMap());
            MqttTopicSubscription existingSubscription = (MqttTopicSubscription)this.subscriptions.get(subscription.topicName());
            if (existingSubscription != null) {
                if (subscription.qualityOfService().value() > existingSubscription.qualityOfService().value()) {
                    this.subscriptions.put(subscription.topicName(), subscription);
                    return true;
                }
            } else {
                this.subscriptions.put(subscription.topicName(), subscription);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscription(String address) {
        ConcurrentMap<String, MqttTopicSubscription> concurrentMap = this.subscriptions;
        synchronized (concurrentMap) {
            this.subscriptions.remove(address);
            this.addressMessageMap.remove(address);
        }
    }

    MqttTopicSubscription getSubscription(String address) {
        return (MqttTopicSubscription)this.subscriptions.get(address);
    }

    String getClientId() {
        return this.clientId;
    }

    void setClientId(String clientId) {
        this.clientId = clientId;
    }

    void removeMessageRef(Integer mqttId) {
        Map addressMap;
        MQTTMessageInfo info = this.messageRefStore.remove(mqttId);
        if (info != null && (addressMap = (Map)this.addressMessageMap.get(info.getAddress())) != null) {
            addressMap.remove(info.getServerMessageId());
        }
    }

    public class OutboundStore {
        private HashMap<Pair<Long, Long>, Integer> artemisToMqttMessageMap = new HashMap();
        private HashMap<Integer, Pair<Long, Long>> mqttToServerIds = new HashMap();
        private final Object dataStoreLock = new Object();
        private final AtomicInteger ids = new AtomicInteger(0);

        private Pair<Long, Long> generateKey(long messageId, long consumerID) {
            return new Pair((Object)messageId, (Object)consumerID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int generateMqttId(long messageId, long consumerId) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                Integer id = this.artemisToMqttMessageMap.get(this.generateKey(messageId, consumerId));
                if (id == null) {
                    this.ids.compareAndSet(Short.MAX_VALUE, 1);
                    id = this.ids.addAndGet(1);
                }
                return id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(int mqtt, long messageId, long consumerId) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                Pair<Long, Long> key = this.generateKey(messageId, consumerId);
                this.artemisToMqttMessageMap.put(key, mqtt);
                this.mqttToServerIds.put(mqtt, key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Pair<Long, Long> publishAckd(int mqtt) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                Pair<Long, Long> p = this.mqttToServerIds.remove(mqtt);
                if (p != null) {
                    this.mqttToServerIds.remove(p.getA());
                    this.artemisToMqttMessageMap.remove(p);
                }
                return p;
            }
        }

        public Pair<Long, Long> publishReceived(int mqtt) {
            return this.publishAckd(mqtt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publishReleasedSent(int mqttId, long serverMessageId) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                this.mqttToServerIds.put(mqttId, (Pair<Long, Long>)new Pair((Object)serverMessageId, (Object)0L));
            }
        }

        public Pair<Long, Long> publishComplete(int mqtt) {
            return this.publishAckd(mqtt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.dataStoreLock;
            synchronized (object) {
                this.artemisToMqttMessageMap.clear();
                this.mqttToServerIds.clear();
                this.ids.set(0);
            }
        }
    }
}

