/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import java.util.Arrays;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.slf4j.Logger;

public class MQTTLogger_impl
implements MQTTLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public MQTTLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void unableToSendMessage(MessageReference message, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ832000: Unable to send message: {}", (Object)message, (Object)e);
        }
    }

    @Override
    public void failedToAckMessage(String clientId, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ832001: MQTT client({}) attempted to ack already ack'd message: ", (Object)clientId, (Object)e);
        }
    }

    @Override
    public void errorRemovingSubscription(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ834000: Error removing subscription.", (Throwable)e);
        }
    }

    @Override
    public void errorDisconnectingClient(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ834001: Error disconnecting client.", (Throwable)e);
        }
    }

    @Override
    public void errorProcessingControlPacket(String packet, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ834002: Error processing control packet: {}", (Object)packet, (Object)e);
        }
    }

    @Override
    public void errorSendingWillMessage(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ834003: Error sending will message.", (Throwable)e);
        }
    }

    @Override
    public void errorDisconnectingConsumer(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ834004: Error disconnecting consumer.", (Throwable)e);
        }
    }

    @Override
    public void failedToCastProperty(String property) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ834005: Failed to cast property {}.", (Object)property);
        }
    }

    @Override
    public void failedToPublishMqttMessage(String exceptionMessage, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ834006: Failed to publish MQTT message: {}.", (Object)exceptionMessage, (Object)t);
        }
    }

    @Override
    public void authorizationFailureSendingWillMessage(String message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ834007: Authorization failure sending will message: {}", (Object)message);
        }
    }
}

