/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jlibaio;

import io.netty.util.internal.ObjectUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.jlibaio.LibaioFile;
import org.apache.activemq.artemis.jlibaio.NativeLogger;
import org.apache.activemq.artemis.jlibaio.SubmitInfo;

public class LibaioContext<Callback extends SubmitInfo>
implements Closeable {
    private static final AtomicLong totalMaxIO;
    private static final int EXPECTED_NATIVE_VERSION = 3;
    private static boolean loaded;
    private static final AtomicBoolean shuttingDown;
    private static final AtomicInteger contexts;
    private final ByteBuffer ioContext;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    final Semaphore ioSpace;
    final int queueSize;

    public static boolean isLoaded() {
        return loaded;
    }

    private static boolean loadLibrary(String name) {
        try {
            System.loadLibrary(name);
            if (LibaioContext.getNativeVersion() != 3) {
                NativeLogger.LOGGER.incompatibleNativeLibrary();
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            NativeLogger.LOGGER.debug(name + " -> error loading the native library", e);
            return false;
        }
    }

    private static void checkShutdown() {
        if (contexts.get() == 0 && shuttingDown.get()) {
            LibaioContext.shutdownHook();
        }
    }

    private static native void shutdownHook();

    public static long getTotalMaxIO() {
        return totalMaxIO.get();
    }

    public void memsetBuffer(ByteBuffer buffer) {
        LibaioContext.memsetBuffer(buffer, buffer.limit());
    }

    public static void resetMaxAIO() {
        totalMaxIO.set(0L);
    }

    public LibaioContext(int queueSize, boolean useSemaphore) {
        contexts.incrementAndGet();
        this.ioContext = this.newContext(queueSize);
        this.queueSize = queueSize;
        totalMaxIO.addAndGet(queueSize);
        this.ioSpace = useSemaphore ? new Semaphore(queueSize) : null;
    }

    public void submitWrite(int fd, long position, int size, ByteBuffer bufferWrite, Callback callback) throws IOException {
        if (this.closed.get()) {
            throw new IOException("Libaio Context is closed!");
        }
        try {
            if (this.ioSpace != null) {
                this.ioSpace.acquire();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e.getMessage(), e);
        }
        this.submitWrite(fd, this.ioContext, position, size, bufferWrite, callback);
    }

    public void submitRead(int fd, long position, int size, ByteBuffer bufferWrite, Callback callback) throws IOException {
        if (this.closed.get()) {
            throw new IOException("Libaio Context is closed!");
        }
        try {
            if (this.ioSpace != null) {
                this.ioSpace.acquire();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e.getMessage(), e);
        }
        this.submitRead(fd, this.ioContext, position, size, bufferWrite, callback);
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.ioSpace != null) {
                try {
                    this.ioSpace.tryAcquire(this.queueSize, 10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    NativeLogger.LOGGER.error(e);
                }
            }
            totalMaxIO.addAndGet(-this.queueSize);
            if (this.ioContext != null) {
                this.deleteContext(this.ioContext);
            }
            contexts.decrementAndGet();
            LibaioContext.checkShutdown();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public LibaioFile<Callback> openFile(File file, boolean direct) throws IOException {
        return this.openFile(file.getPath(), direct);
    }

    public LibaioFile<Callback> openFile(String file, boolean direct) throws IOException {
        ObjectUtil.checkNotNull((Object)file, (String)"path");
        ObjectUtil.checkNotNull((Object)this.ioContext, (String)"IOContext");
        int res = LibaioContext.open(file, direct);
        return new LibaioFile(res, this);
    }

    public static LibaioFile openControlFile(String file, boolean direct) throws IOException {
        ObjectUtil.checkNotNull((Object)file, (String)"path");
        int res = LibaioContext.open(file, direct);
        return new LibaioFile(res, null);
    }

    public int poll(Callback[] callbacks, int min, int max) {
        int released = this.poll(this.ioContext, (SubmitInfo[])callbacks, min, max);
        if (this.ioSpace != null && released > 0) {
            this.ioSpace.release(released);
        }
        return released;
    }

    public void poll() {
        if (!this.closed.get()) {
            this.blockedPoll(this.ioContext);
        }
    }

    private void done(SubmitInfo info) {
        info.done();
        if (this.ioSpace != null) {
            this.ioSpace.release();
        }
    }

    private native ByteBuffer newContext(int var1);

    private native void deleteContext(ByteBuffer var1);

    public static native int open(String var0, boolean var1);

    static native void close(int var0);

    public static native ByteBuffer newAlignedBuffer(int var0, int var1);

    public static native void freeBuffer(ByteBuffer var0);

    native void submitWrite(int var1, ByteBuffer var2, long var3, int var5, ByteBuffer var6, Callback var7) throws IOException;

    native void submitRead(int var1, ByteBuffer var2, long var3, int var5, ByteBuffer var6, Callback var7) throws IOException;

    native int poll(ByteBuffer var1, Callback[] var2, int var3, int var4);

    native void blockedPoll(ByteBuffer var1);

    static native int getNativeVersion();

    public static native boolean lock(int var0);

    public static native void memsetBuffer(ByteBuffer var0, int var1);

    static native long getSize(int var0);

    static native int getBlockSizeFD(int var0);

    public static int getBlockSize(File path) {
        return LibaioContext.getBlockSize(path.getAbsolutePath());
    }

    public static native int getBlockSize(String var0);

    static native void fallocate(int var0, long var1);

    static native void fill(int var0, long var1);

    static native void writeInternal(int var0, long var1, long var3, ByteBuffer var5) throws IOException;

    static {
        String[] libraries;
        totalMaxIO = new AtomicLong(0L);
        loaded = false;
        shuttingDown = new AtomicBoolean(false);
        contexts = new AtomicInteger(0);
        for (String library : libraries = new String[]{"artemis-native-64", "artemis-native-32"}) {
            if (LibaioContext.loadLibrary(library)) {
                loaded = true;
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        shuttingDown.set(true);
                        LibaioContext.checkShutdown();
                    }
                });
                break;
            }
            NativeLogger.LOGGER.debug("Library " + library + " not found!");
        }
        if (!loaded) {
            NativeLogger.LOGGER.debug("Couldn't locate LibAIO Wrapper");
        }
    }
}

