/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @module ARTEMIS
 */
var ARTEMIS = (function(ARTEMIS) {

  ARTEMIS.SERVER = 'Server Messages';


  // The ARTEMIS service handles the connection to
  // the Artemis Jolokia server in the background
  ARTEMIS.module.factory("ARTEMISService", function(jolokia, $rootScope) {
    var self = {
      artemisConsole: undefined,

      getVersion: function(jolokia) {
        ARTEMIS.log.info("Connecting to ARTEMIS service: " + self.artemisConsole.getServerAttributes(jolokia));
      } ,
      initArtemis: function(broker) {
        ARTEMIS.log.info("*************creating Artemis Console************");
        self.artemisConsole = new ArtemisConsole();
      }
    };

    return self;
  });

  return ARTEMIS;
}(ARTEMIS || {}));
