/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.hawtio.plugin;

import io.hawt.web.plugin.HawtioPlugin;
import java.lang.invoke.MethodHandles;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginContextListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    HawtioPlugin plugin = null;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext context = servletContextEvent.getServletContext();
        this.plugin = new HawtioPlugin();
        this.plugin.setContext(context.getContextPath());
        this.plugin.setName(context.getInitParameter("plugin-name"));
        this.plugin.setScripts(context.getInitParameter("plugin-scripts"));
        this.plugin.setDomain(null);
        try {
            this.plugin.init();
        }
        catch (Exception e) {
            throw this.createServletException(e);
        }
        logger.info("Initialized {} plugin", (Object)this.plugin.getName());
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            this.plugin.destroy();
        }
        catch (Exception e) {
            throw this.createServletException(e);
        }
        logger.info("Destroyed {} plugin", (Object)this.plugin.getName());
    }

    protected RuntimeException createServletException(Exception e) {
        return new RuntimeException(e);
    }
}

