/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.jboss.logging.Logger;
import org.proton.plug.AMQPConnectionCallback;
import org.proton.plug.AMQPConnectionContext;
import org.proton.plug.SASLResult;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.context.ProtonDeliveryHandler;
import org.proton.plug.context.ProtonInitializable;
import org.proton.plug.context.server.ProtonServerSenderContext;
import org.proton.plug.exceptions.ActiveMQAMQPException;
import org.proton.plug.handler.ProtonHandler;
import org.proton.plug.handler.impl.DefaultEventHandler;
import org.proton.plug.util.ByteUtil;

public abstract class AbstractConnectionContext
extends ProtonInitializable
implements AMQPConnectionContext {
    private static final Logger log = Logger.getLogger(AbstractConnectionContext.class);
    public static final Symbol CONNECTION_OPEN_FAILED = Symbol.valueOf((String)"amqp:connection-establishment-failed");
    public static final String AMQP_CONTAINER_ID = "amqp-container-id";
    protected final ProtonHandler handler;
    protected AMQPConnectionCallback connectionCallback;
    private final String containerId;
    private final Map<Symbol, Object> connectionProperties = new HashMap<Symbol, Object>();
    private final ScheduledExecutorService scheduledPool;
    private final Map<Session, AbstractProtonSessionContext> sessions = new ConcurrentHashMap<Session, AbstractProtonSessionContext>();
    protected LocalListener listener = new LocalListener();

    public AbstractConnectionContext(AMQPConnectionCallback connectionCallback, Executor dispatchExecutor, ScheduledExecutorService scheduledPool) {
        this(connectionCallback, null, -1, -1, 65535, dispatchExecutor, scheduledPool);
    }

    public AbstractConnectionContext(AMQPConnectionCallback connectionCallback, String containerId, int idleTimeout, int maxFrameSize, int channelMax, Executor dispatchExecutor, ScheduledExecutorService scheduledPool) {
        this.connectionCallback = connectionCallback;
        this.containerId = containerId != null ? containerId : UUID.randomUUID().toString();
        this.connectionProperties.put(Symbol.valueOf((String)"product"), "apache-activemq-artemis");
        this.connectionProperties.put(Symbol.valueOf((String)"version"), VersionLoader.getVersion().getFullVersion());
        this.scheduledPool = scheduledPool;
        connectionCallback.setConnection(this);
        this.handler = ProtonHandler.Factory.create(dispatchExecutor);
        Transport transport = this.handler.getTransport();
        transport.setEmitFlowEventOnSend(false);
        if (idleTimeout > 0) {
            transport.setIdleTimeout(idleTimeout);
        }
        transport.setChannelMax(channelMax);
        transport.setMaxFrameSize(maxFrameSize);
        this.handler.addEventHandler(this.listener);
    }

    @Override
    public SASLResult getSASLResult() {
        return this.handler.getSASLResult();
    }

    @Override
    public void inputBuffer(ByteBuf buffer) {
        if (log.isTraceEnabled()) {
            ByteUtil.debugFrame(log, "Buffer Received ", buffer);
        }
        this.handler.inputBuffer(buffer);
    }

    public void destroy() {
        this.connectionCallback.close();
    }

    @Override
    public boolean isSyncOnFlush() {
        return false;
    }

    @Override
    public Object getLock() {
        return this.handler.getLock();
    }

    @Override
    public int capacity() {
        return this.handler.capacity();
    }

    @Override
    public void outputDone(int bytes) {
        this.handler.outputDone(bytes);
    }

    @Override
    public void flush() {
        this.handler.flush();
    }

    @Override
    public void close() {
        this.handler.close();
    }

    protected AbstractProtonSessionContext getSessionExtension(Session realSession) throws ActiveMQAMQPException {
        AbstractProtonSessionContext sessionExtension = this.sessions.get(realSession);
        if (sessionExtension == null) {
            sessionExtension = this.newSessionExtension(realSession);
            realSession.setContext((Object)sessionExtension);
            this.sessions.put(realSession, sessionExtension);
        }
        return sessionExtension;
    }

    protected abstract void remoteLinkOpened(Link var1) throws Exception;

    protected abstract AbstractProtonSessionContext newSessionExtension(Session var1) throws ActiveMQAMQPException;

    @Override
    public boolean checkDataReceived() {
        return this.handler.checkDataReceived();
    }

    @Override
    public long getCreationTime() {
        return this.handler.getCreationTime();
    }

    protected void flushBytes() {
        ByteBuf bytes;
        while ((bytes = this.handler.outputBuffer()) != null) {
            this.connectionCallback.onTransport(bytes, this);
        }
    }

    public String getRemoteContainer() {
        return this.handler.getConnection().getRemoteContainer();
    }

    public String getPubSubPrefix() {
        return null;
    }

    class LocalListener
    extends DefaultEventHandler {
        LocalListener() {
        }

        @Override
        public void onAuthInit(ProtonHandler handler, Connection connection, boolean sasl) {
            if (sasl) {
                handler.createServerSASL(AbstractConnectionContext.this.connectionCallback.getSASLMechnisms());
            } else if (!AbstractConnectionContext.this.connectionCallback.isSupportsAnonymous()) {
                AbstractConnectionContext.this.connectionCallback.sendSASLSupported();
                AbstractConnectionContext.this.connectionCallback.close();
                handler.close();
            }
        }

        @Override
        public void onTransport(Transport transport) {
            AbstractConnectionContext.this.flushBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteOpen(Connection connection) throws Exception {
            Object object = AbstractConnectionContext.this.getLock();
            synchronized (object) {
                connection.setContext((Object)AbstractConnectionContext.this);
                connection.setContainer(AbstractConnectionContext.this.containerId);
                connection.setProperties(AbstractConnectionContext.this.connectionProperties);
                connection.open();
            }
            AbstractConnectionContext.this.initialise();
            if (connection.getRemoteProperties() == null || !connection.getRemoteProperties().containsKey(CONNECTION_OPEN_FAILED)) {
                long nextKeepAliveTime = AbstractConnectionContext.this.handler.tick(true);
                AbstractConnectionContext.this.flushBytes();
                if (nextKeepAliveTime > 0L && AbstractConnectionContext.this.scheduledPool != null) {
                    AbstractConnectionContext.this.scheduledPool.schedule(new Runnable(){

                        @Override
                        public void run() {
                            long rescheduleAt = AbstractConnectionContext.this.handler.tick(false) - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                            AbstractConnectionContext.this.flushBytes();
                            if (rescheduleAt > 0L) {
                                AbstractConnectionContext.this.scheduledPool.schedule(this, rescheduleAt, TimeUnit.MILLISECONDS);
                            }
                        }
                    }, nextKeepAliveTime - TimeUnit.NANOSECONDS.toMillis(System.nanoTime()), TimeUnit.MILLISECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteClose(Connection connection) {
            Object object = AbstractConnectionContext.this.getLock();
            synchronized (object) {
                connection.close();
                for (AbstractProtonSessionContext protonSession : AbstractConnectionContext.this.sessions.values()) {
                    protonSession.close();
                }
                AbstractConnectionContext.this.sessions.clear();
            }
            this.onTransport(AbstractConnectionContext.this.handler.getTransport());
            AbstractConnectionContext.this.destroy();
        }

        @Override
        public void onLocalOpen(Session session) throws Exception {
            AbstractConnectionContext.this.getSessionExtension(session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteOpen(Session session) throws Exception {
            AbstractConnectionContext.this.getSessionExtension(session).initialise();
            Object object = AbstractConnectionContext.this.getLock();
            synchronized (object) {
                session.open();
            }
        }

        @Override
        public void onLocalClose(Session session) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteClose(Session session) throws Exception {
            Object object = AbstractConnectionContext.this.getLock();
            synchronized (object) {
                session.close();
            }
            AbstractProtonSessionContext sessionContext = (AbstractProtonSessionContext)session.getContext();
            if (sessionContext != null) {
                sessionContext.close();
                AbstractConnectionContext.this.sessions.remove(session);
                session.setContext(null);
            }
        }

        @Override
        public void onRemoteOpen(Link link) throws Exception {
            AbstractConnectionContext.this.remoteLinkOpened(link);
        }

        @Override
        public void onFlow(Link link) throws Exception {
            ((ProtonDeliveryHandler)link.getContext()).onFlow(link.getCredit(), link.getDrain());
        }

        @Override
        public void onRemoteClose(Link link) throws Exception {
            link.close();
            ProtonDeliveryHandler linkContext = (ProtonDeliveryHandler)link.getContext();
            if (linkContext != null) {
                linkContext.close(true);
            }
        }

        @Override
        public void onRemoteDetach(Link link) throws Exception {
            link.detach();
        }

        @Override
        public void onDetach(Link link) throws Exception {
            Object context = link.getContext();
            if (context instanceof ProtonServerSenderContext) {
                ProtonServerSenderContext senderContext = (ProtonServerSenderContext)context;
                senderContext.close(false);
            }
        }

        @Override
        public void onDelivery(Delivery delivery) throws Exception {
            ProtonDeliveryHandler handler = (ProtonDeliveryHandler)delivery.getLink().getContext();
            if (handler != null) {
                handler.onMessage(delivery);
            } else {
                System.err.println("Handler is null, can't delivery " + delivery);
            }
        }
    }
}

