/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.ProtonJMessage;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.context.ProtonDeliveryHandler;
import org.proton.plug.context.ProtonInitializable;
import org.proton.plug.exceptions.ActiveMQAMQPException;
import org.proton.plug.util.CreditsSemaphore;
import org.proton.plug.util.NettyWritable;

public abstract class AbstractProtonContextSender
extends ProtonInitializable
implements ProtonDeliveryHandler {
    protected final AbstractProtonSessionContext protonSession;
    protected final Sender sender;
    protected final AbstractConnectionContext connection;
    protected boolean closed = false;
    protected final AMQPSessionCallback sessionSPI;
    protected CreditsSemaphore creditsSemaphore = new CreditsSemaphore(0);

    public AbstractProtonContextSender(AbstractConnectionContext connection, Sender sender, AbstractProtonSessionContext protonSession, AMQPSessionCallback server) {
        this.connection = connection;
        this.sender = sender;
        this.protonSession = protonSession;
        this.sessionSPI = server;
    }

    @Override
    public void onFlow(int credits, boolean drain) {
        this.creditsSemaphore.setCredits(credits);
    }

    public void start() throws ActiveMQAMQPException {
        this.sessionSPI.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean linkRemoteClose) throws ActiveMQAMQPException {
        this.closed = true;
        this.protonSession.removeSender(this.sender);
        Object object = this.connection.getLock();
        synchronized (object) {
            this.sender.close();
        }
        this.connection.flush();
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
        this.closed = true;
        this.sender.setCondition(condition);
        this.close(false);
    }

    @Override
    public abstract void onMessage(Delivery var1) throws ActiveMQAMQPException;

    public void checkState() {
    }

    public Sender getSender() {
        return this.sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int performSend(ProtonJMessage serverMessage, Object context) {
        if (!this.creditsSemaphore.tryAcquire()) {
            try {
                this.creditsSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        boolean preSettle = this.sender.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED;
        byte[] tag = preSettle ? new byte[]{} : this.protonSession.getTag();
        ByteBuf nettyBuffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        try {
            serverMessage.encode((WritableBuffer)new NettyWritable(nettyBuffer));
            int size = nettyBuffer.writerIndex();
            Object object = this.connection.getLock();
            synchronized (object) {
                Delivery delivery = this.sender.delivery(tag, 0, tag.length);
                delivery.setContext(context);
                this.sender.send(nettyBuffer.array(), nettyBuffer.arrayOffset() + nettyBuffer.readerIndex(), nettyBuffer.readableBytes());
                if (preSettle) {
                    delivery.settle();
                } else {
                    this.sender.advance();
                }
            }
            this.connection.flush();
            int n = size;
            return n;
        }
        finally {
            nettyBuffer.release();
        }
    }
}

