/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.jboss.logging.Logger;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.AMQPSessionContext;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonContextSender;
import org.proton.plug.context.AbstractProtonReceiverContext;
import org.proton.plug.context.ProtonInitializable;
import org.proton.plug.exceptions.ActiveMQAMQPException;
import org.proton.plug.exceptions.ActiveMQAMQPInternalErrorException;

public abstract class AbstractProtonSessionContext
extends ProtonInitializable
implements AMQPSessionContext {
    private static final Logger log = Logger.getLogger(AbstractProtonSessionContext.class);
    protected final AbstractConnectionContext connection;
    protected final AMQPSessionCallback sessionSPI;
    protected final Session session;
    private long currentTag = 0L;
    protected Map<Receiver, AbstractProtonReceiverContext> receivers = new HashMap<Receiver, AbstractProtonReceiverContext>();
    protected Map<Sender, AbstractProtonContextSender> senders = new HashMap<Sender, AbstractProtonContextSender>();
    protected boolean closed = false;

    public AbstractProtonSessionContext(AMQPSessionCallback sessionSPI, AbstractConnectionContext connection, Session session) {
        this.connection = connection;
        this.sessionSPI = sessionSPI;
        this.session = session;
    }

    @Override
    public void initialise() throws Exception {
        if (!this.isInitialized()) {
            super.initialise();
            if (this.sessionSPI != null) {
                try {
                    this.sessionSPI.init(this, this.connection.getSASLResult());
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
            }
        }
    }

    public void disconnect(Object consumer, String queueName) {
        AbstractProtonContextSender protonConsumer = this.senders.remove(consumer);
        if (protonConsumer != null) {
            try {
                protonConsumer.close(false);
            }
            catch (ActiveMQAMQPException e) {
                protonConsumer.getSender().setTarget(null);
                protonConsumer.getSender().setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            }
        }
    }

    @Override
    public byte[] getTag() {
        return Long.toHexString(this.currentTag++).getBytes();
    }

    @Override
    public void replaceTag(byte[] tag) {
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        HashSet<AbstractProtonReceiverContext> receiversCopy = new HashSet<AbstractProtonReceiverContext>();
        receiversCopy.addAll(this.receivers.values());
        for (AbstractProtonReceiverContext abstractProtonReceiverContext : receiversCopy) {
            try {
                abstractProtonReceiverContext.close(false);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.receivers.clear();
        HashSet<AbstractProtonContextSender> protonSendersClone = new HashSet<AbstractProtonContextSender>();
        protonSendersClone.addAll(this.senders.values());
        for (AbstractProtonContextSender protonConsumer : protonSendersClone) {
            try {
                protonConsumer.close(false);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.senders.clear();
        try {
            if (this.sessionSPI != null) {
                this.sessionSPI.rollbackCurrentTX(false);
                this.sessionSPI.close();
            }
        }
        catch (Exception exception) {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
        }
        this.closed = true;
    }

    @Override
    public void removeSender(Sender sender) throws ActiveMQAMQPException {
        this.senders.remove(sender);
    }

    @Override
    public void removeReceiver(Receiver receiver) {
        this.receivers.remove(receiver);
    }
}

