/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.jboss.logging.Logger;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.context.ProtonDeliveryHandler;
import org.proton.plug.exceptions.ActiveMQAMQPException;
import org.proton.plug.logger.ActiveMQAMQPProtocolMessageBundle;
import org.proton.plug.util.DeliveryUtil;

public class ProtonTransactionHandler
implements ProtonDeliveryHandler {
    private static final Logger log = Logger.getLogger(ProtonTransactionHandler.class);
    final AMQPSessionCallback sessionSPI;

    public ProtonTransactionHandler(AMQPSessionCallback sessionSPI) {
        this.sessionSPI = sessionSPI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        block16: {
            ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
            try {
                Receiver receiver = (Receiver)delivery.getLink();
                if (!delivery.isReadable()) {
                    return;
                }
                DeliveryUtil.readDelivery(receiver, buffer);
                receiver.advance();
                MessageImpl msg = DeliveryUtil.decodeMessageImpl(buffer);
                Object action = ((AmqpValue)msg.getBody()).getValue();
                if (action instanceof Declare) {
                    Binary txID = this.sessionSPI.getCurrentTXID();
                    Declared declared = new Declared();
                    declared.setTxnId(txID);
                    delivery.disposition((DeliveryState)declared);
                    delivery.settle();
                    break block16;
                }
                if (!(action instanceof Discharge)) break block16;
                Discharge discharge = (Discharge)action;
                if (discharge.getFail().booleanValue()) {
                    try {
                        this.sessionSPI.rollbackCurrentTX(true);
                        delivery.disposition((DeliveryState)new Accepted());
                        break block16;
                    }
                    catch (Exception e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorRollingbackCoordinator(e.getMessage());
                    }
                }
                try {
                    this.sessionSPI.commitCurrentTX();
                    delivery.disposition((DeliveryState)new Accepted());
                }
                catch (ActiveMQAMQPException amqpE) {
                    throw amqpE;
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCommittingCoordinator(e.getMessage());
                }
            }
            catch (ActiveMQAMQPException amqpE) {
                delivery.disposition((DeliveryState)this.createRejected(amqpE.getAmqpError(), amqpE.getMessage()));
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                delivery.disposition((DeliveryState)this.createRejected(Symbol.getSymbol((String)"failed"), e.getMessage()));
            }
            finally {
                delivery.settle();
                buffer.release();
            }
        }
    }

    private Rejected createRejected(Symbol amqpError, String message) {
        Rejected rejected = new Rejected();
        ErrorCondition condition = new ErrorCondition();
        condition.setCondition(amqpError);
        condition.setDescription(message);
        rejected.setError(condition);
        return rejected;
    }

    @Override
    public void onFlow(int credits, boolean drain) {
    }

    @Override
    public void close(boolean linkRemoteClose) throws ActiveMQAMQPException {
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
    }
}

