/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context.client;

import java.util.HashMap;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.DeleteOnClose;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.proton.plug.AMQPClientReceiverContext;
import org.proton.plug.AMQPClientSenderContext;
import org.proton.plug.AMQPClientSessionContext;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.AmqpSupport;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.context.client.ProtonClientContext;
import org.proton.plug.context.client.ProtonClientReceiverContext;
import org.proton.plug.exceptions.ActiveMQAMQPException;
import org.proton.plug.util.FutureRunnable;

public class ProtonClientSessionContext
extends AbstractProtonSessionContext
implements AMQPClientSessionContext {
    public ProtonClientSessionContext(AMQPSessionCallback sessionSPI, AbstractConnectionContext connection, Session session) {
        super(sessionSPI, connection, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMQPClientSenderContext createSender(String address, boolean preSettled) throws ActiveMQAMQPException {
        ProtonClientContext amqpSender;
        FutureRunnable futureRunnable = new FutureRunnable(1);
        Object object = this.connection.getLock();
        synchronized (object) {
            Sender sender = this.session.sender(address);
            sender.setSenderSettleMode(SenderSettleMode.SETTLED);
            Target target = new Target();
            target.setAddress(address);
            sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
            amqpSender = new ProtonClientContext(this.connection, sender, this, this.sessionSPI);
            amqpSender.afterInit(futureRunnable);
            sender.setContext((Object)amqpSender);
            sender.open();
        }
        this.connection.flush();
        this.waitWithTimeout(futureRunnable);
        return amqpSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMQPClientSenderContext createDynamicSender(boolean preSettled) throws ActiveMQAMQPException {
        ProtonClientContext amqpSender;
        FutureRunnable futureRunnable = new FutureRunnable(1);
        Object object = this.connection.getLock();
        synchronized (object) {
            String senderName = "Dynamic-" + UUID.randomUUID().toString();
            Sender sender = this.session.sender(senderName);
            sender.setSenderSettleMode(SenderSettleMode.SETTLED);
            Symbol[] outcomes = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL};
            Source source = new Source();
            source.setAddress(senderName);
            source.setOutcomes(outcomes);
            Target target = new Target();
            target.setDynamic(true);
            target.setDurable(TerminusDurability.NONE);
            target.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
            HashMap<Symbol, DeleteOnClose> dynamicNodeProperties = new HashMap<Symbol, DeleteOnClose>();
            dynamicNodeProperties.put(AmqpSupport.LIFETIME_POLICY, DeleteOnClose.getInstance());
            target.setDynamicNodeProperties(dynamicNodeProperties);
            amqpSender = new ProtonClientContext(this.connection, sender, this, this.sessionSPI);
            amqpSender.afterInit(futureRunnable);
            sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
            sender.setContext((Object)amqpSender);
            sender.open();
        }
        this.connection.flush();
        this.waitWithTimeout(futureRunnable);
        return amqpSender;
    }

    @Override
    public AMQPClientReceiverContext createReceiver(String address) throws ActiveMQAMQPException {
        return this.createReceiver(address, address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMQPClientReceiverContext createReceiver(String name, String address) throws ActiveMQAMQPException {
        ProtonClientReceiverContext amqpReceiver;
        FutureRunnable futureRunnable = new FutureRunnable(1);
        Object object = this.connection.getLock();
        synchronized (object) {
            Receiver receiver = this.session.receiver(name);
            Source source = new Source();
            source.setAddress(address);
            receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            amqpReceiver = new ProtonClientReceiverContext(this.sessionSPI, this.connection, this, receiver);
            receiver.setContext((Object)amqpReceiver);
            amqpReceiver.afterInit(futureRunnable);
            receiver.open();
        }
        this.connection.flush();
        this.waitWithTimeout(futureRunnable);
        return amqpReceiver;
    }
}

