/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context.server;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.proton.plug.AMQPConnectionCallback;
import org.proton.plug.AMQPServerConnectionContext;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.context.server.ProtonServerSessionContext;
import org.proton.plug.exceptions.ActiveMQAMQPException;

public class ProtonServerConnectionContext
extends AbstractConnectionContext
implements AMQPServerConnectionContext {
    public ProtonServerConnectionContext(AMQPConnectionCallback connectionSP, Executor dispatchExecutor, ScheduledExecutorService scheduledPool) {
        super(connectionSP, dispatchExecutor, scheduledPool);
    }

    public ProtonServerConnectionContext(AMQPConnectionCallback connectionSP, String containerId, int idleTimeout, int maxFrameSize, int channelMax, Executor dispatchExecutor, ScheduledExecutorService scheduledPool) {
        super(connectionSP, containerId, idleTimeout, maxFrameSize, channelMax, dispatchExecutor, scheduledPool);
    }

    @Override
    protected AbstractProtonSessionContext newSessionExtension(Session realSession) throws ActiveMQAMQPException {
        AMQPSessionCallback sessionSPI = this.connectionCallback.createSessionCallback(this);
        ProtonServerSessionContext protonSession = new ProtonServerSessionContext(sessionSPI, this, realSession);
        return protonSession;
    }

    @Override
    protected void remoteLinkOpened(Link link) throws Exception {
        ProtonServerSessionContext protonSession = (ProtonServerSessionContext)this.getSessionExtension(link.getSession());
        link.setSource(link.getRemoteSource());
        link.setTarget(link.getRemoteTarget());
        if (link instanceof Receiver) {
            Receiver receiver = (Receiver)link;
            if (link.getRemoteTarget() instanceof Coordinator) {
                Coordinator coordinator = (Coordinator)link.getRemoteTarget();
                protonSession.addTransactionHandler(coordinator, receiver);
            } else {
                protonSession.addReceiver(receiver);
            }
        } else {
            Sender sender = (Sender)link;
            protonSession.addSender(sender);
            sender.offer(1);
        }
    }
}

