/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.jboss.logging.Logger;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonReceiverContext;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.exceptions.ActiveMQAMQPException;
import org.proton.plug.exceptions.ActiveMQAMQPInternalErrorException;
import org.proton.plug.exceptions.ActiveMQAMQPNotFoundException;
import org.proton.plug.logger.ActiveMQAMQPProtocolMessageBundle;
import org.proton.plug.util.DeliveryUtil;

public class ProtonServerReceiverContext
extends AbstractProtonReceiverContext {
    private static final Logger log = Logger.getLogger(ProtonServerReceiverContext.class);
    private static int maxCreditAllocation = 100;
    private static int minCreditRefresh = 30;

    public ProtonServerReceiverContext(AMQPSessionCallback sessionSPI, AbstractConnectionContext connection, AbstractProtonSessionContext protonSession, Receiver receiver) {
        super(sessionSPI, connection, protonSession, receiver);
    }

    @Override
    public void onFlow(int credits, boolean drain) {
        this.flow(Math.min(credits, maxCreditAllocation), maxCreditAllocation);
    }

    @Override
    public void initialise() throws Exception {
        super.initialise();
        Target target = (Target)this.receiver.getRemoteTarget();
        if (target != null) {
            if (target.getDynamic()) {
                this.address = this.sessionSPI.tempQueueName();
                try {
                    this.sessionSPI.createTemporaryQueue(this.address);
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
                target.setAddress(this.address);
            } else {
                this.address = target.getAddress();
                if (this.address == null) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.targetAddressNotSet();
                }
                try {
                    if (!this.sessionSPI.bindingQuery(this.address)) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist();
                    }
                }
                catch (ActiveMQAMQPNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
            }
        }
        this.flow(maxCreditAllocation, minCreditRefresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        try {
            Receiver receiver = (Receiver)delivery.getLink();
            if (!delivery.isReadable()) {
                return;
            }
            if (delivery.isPartial()) {
                return;
            }
            ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(10240);
            try {
                Object object = this.connection.getLock();
                synchronized (object) {
                    DeliveryUtil.readDelivery(receiver, buffer);
                    receiver.advance();
                    this.sessionSPI.serverSend(receiver, delivery, this.address, delivery.getMessageFormat(), buffer);
                    this.flow(maxCreditAllocation, minCreditRefresh);
                }
            }
            finally {
                buffer.release();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            Rejected rejected = new Rejected();
            ErrorCondition condition = new ErrorCondition();
            condition.setCondition(Symbol.valueOf((String)"failed"));
            condition.setDescription(e.getMessage());
            rejected.setError(condition);
            delivery.disposition((DeliveryState)rejected);
        }
    }
}

