/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context.server;

import java.util.Map;
import java.util.UUID;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.ProtonJMessage;
import org.jboss.logging.Logger;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.AmqpSupport;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonContextSender;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.context.ProtonPlugSender;
import org.proton.plug.exceptions.ActiveMQAMQPException;
import org.proton.plug.exceptions.ActiveMQAMQPInternalErrorException;
import org.proton.plug.exceptions.ActiveMQAMQPNotFoundException;
import org.proton.plug.logger.ActiveMQAMQPProtocolMessageBundle;

public class ProtonServerSenderContext
extends AbstractProtonContextSender
implements ProtonPlugSender {
    private static final Logger log = Logger.getLogger(ProtonServerSenderContext.class);
    private static final Symbol SELECTOR = Symbol.getSymbol((String)"jms-selector");
    private static final Symbol COPY = Symbol.valueOf((String)"copy");
    private static final Symbol TOPIC = Symbol.valueOf((String)"topic");
    private Object brokerConsumer;

    public ProtonServerSenderContext(AbstractConnectionContext connection, Sender sender, AbstractProtonSessionContext protonSession, AMQPSessionCallback server) {
        super(connection, sender, protonSession, server);
    }

    public Object getBrokerConsumer() {
        return this.brokerConsumer;
    }

    @Override
    public void onFlow(int currentCredits, boolean drain) {
        super.onFlow(currentCredits, drain);
        this.sessionSPI.onFlowConsumer(this.brokerConsumer, currentCredits, drain);
    }

    @Override
    public void start() throws ActiveMQAMQPException {
        super.start();
        try {
            if (this.brokerConsumer != null) {
                this.sessionSPI.startSender(this.brokerConsumer);
            }
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorStartingConsumer(e.getMessage());
        }
    }

    @Override
    public void initialise() throws Exception {
        boolean isPubSub;
        Map.Entry<Symbol, DescribedType> filter;
        super.initialise();
        Source source = (Source)this.sender.getRemoteSource();
        String selector = null;
        if (source != null && (filter = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.JMS_SELECTOR_FILTER_IDS)) != null) {
            selector = filter.getValue().getDescribed().toString();
            try {
                SelectorParser.parse((String)selector);
            }
            catch (FilterException e) {
                this.close(new ErrorCondition(AmqpError.INVALID_FIELD, e.getMessage()));
                return;
            }
        }
        boolean bl = isPubSub = ProtonServerSenderContext.hasCapabilities(TOPIC, source) || this.isPubSub(source);
        if (source == null) {
            String clientId = this.connection.getRemoteContainer();
            String pubId = this.sender.getName();
            String queue = clientId + ":" + pubId;
            boolean exists = this.sessionSPI.queueQuery(queue);
            if (exists) {
                source = new Source();
                source.setAddress(queue);
                source.setDurable(TerminusDurability.UNSETTLED_STATE);
                source.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
                source.setDistributionMode(COPY);
                source.setCapabilities(new Symbol[]{TOPIC});
                this.sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            } else {
                this.sender.setCondition(new ErrorCondition(AmqpError.NOT_FOUND, "Unknown subscription link: " + this.sender.getName()));
                this.sender.close();
            }
        } else {
            String queue;
            if (source.getDynamic()) {
                queue = UUID.randomUUID().toString();
                try {
                    this.sessionSPI.createTemporaryQueue(queue);
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
                }
                source.setAddress(queue);
            } else {
                if (isPubSub) {
                    if (TerminusDurability.UNSETTLED_STATE.equals((Object)source.getDurable()) || TerminusDurability.CONFIGURATION.equals((Object)source.getDurable())) {
                        String clientId = this.connection.getRemoteContainer();
                        String pubId = this.sender.getName();
                        queue = clientId + ":" + pubId;
                        boolean exists = this.sessionSPI.queueQuery(queue);
                        if (!exists) {
                            this.sessionSPI.createDurableQueue(source.getAddress(), queue);
                        }
                    } else {
                        queue = UUID.randomUUID().toString();
                        try {
                            this.sessionSPI.createTemporaryQueue(source.getAddress(), queue);
                        }
                        catch (Exception e) {
                            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
                        }
                        source.setAddress(queue);
                    }
                } else {
                    queue = source.getAddress();
                }
                if (queue == null) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressNotSet();
                }
                try {
                    if (!this.sessionSPI.queueQuery(queue)) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                    }
                }
                catch (ActiveMQAMQPNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
            }
            boolean browseOnly = !isPubSub && source.getDistributionMode() != null && source.getDistributionMode().equals(COPY);
            try {
                this.brokerConsumer = this.sessionSPI.createSender(this, queue, selector, browseOnly);
            }
            catch (Exception e) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingConsumer(e.getMessage());
            }
        }
    }

    private boolean isPubSub(Source source) {
        String pubSubPrefix = this.sessionSPI.getPubSubPrefix();
        return source != null && pubSubPrefix != null && source.getAddress() != null && source.getAddress().startsWith(pubSubPrefix);
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
        super.close(condition);
        try {
            this.sessionSPI.closeSender(this.brokerConsumer);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new ActiveMQAMQPInternalErrorException(e.getMessage());
        }
    }

    @Override
    public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
        super.close(remoteLinkClose);
        try {
            String address;
            boolean exists;
            Source source;
            this.sessionSPI.closeSender(this.brokerConsumer);
            if (remoteLinkClose && (source = (Source)this.sender.getSource()) != null && source.getAddress() != null && ProtonServerSenderContext.hasCapabilities(TOPIC, source) && (exists = this.sessionSPI.queueQuery(address = source.getAddress()))) {
                this.sessionSPI.deleteQueue(address);
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new ActiveMQAMQPInternalErrorException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        Object message = delivery.getContext();
        boolean preSettle = this.sender.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED;
        DeliveryState remoteState = delivery.getRemoteState();
        if (remoteState != null) {
            if (remoteState instanceof TransactionalState) {
                Outcome outcome;
                TransactionalState txState = (TransactionalState)remoteState;
                if (txState.getOutcome() != null && (outcome = txState.getOutcome()) instanceof Accepted) {
                    if (!delivery.remotelySettled()) {
                        TransactionalState txAccepted = new TransactionalState();
                        txAccepted.setOutcome((Outcome)Accepted.getInstance());
                        txAccepted.setTxnId(txState.getTxnId());
                        delivery.disposition((DeliveryState)txAccepted);
                    }
                    try {
                        this.sessionSPI.ack(this.brokerConsumer, message);
                    }
                    catch (Exception e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorAcknowledgingMessage(message.toString(), e.getMessage());
                    }
                }
            } else {
                if (remoteState instanceof Accepted) {
                    try {
                        this.sessionSPI.ack(this.brokerConsumer, message);
                    }
                    catch (Exception e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorAcknowledgingMessage(message.toString(), e.getMessage());
                    }
                }
                if (remoteState instanceof Released) {
                    try {
                        this.sessionSPI.cancel(this.brokerConsumer, message, false);
                    }
                    catch (Exception e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                    }
                }
                if (remoteState instanceof Rejected || remoteState instanceof Modified) {
                    try {
                        this.sessionSPI.cancel(this.brokerConsumer, message, true);
                    }
                    catch (Exception e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                    }
                }
            }
            if (!preSettle) {
                this.protonSession.replaceTag(delivery.getTag());
            }
            Object object = this.connection.getLock();
            synchronized (object) {
                delivery.settle();
                this.sender.offer(1);
            }
        }
    }

    @Override
    public synchronized void checkState() {
        super.checkState();
        this.sessionSPI.resumeDelivery(this.brokerConsumer);
    }

    @Override
    public int deliverMessage(Object message, int deliveryCount) throws Exception {
        ProtonJMessage serverMessage;
        if (this.closed) {
            System.err.println("Message can't be delivered as it's closed");
            return 0;
        }
        try {
            serverMessage = this.sessionSPI.encodeMessage(message, deliveryCount);
        }
        catch (Throwable e) {
            log.warn((Object)e.getMessage(), e);
            throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
        }
        return this.performSend(serverMessage, message);
    }

    private static boolean hasCapabilities(Symbol symbol, Source source) {
        if (source != null && source.getCapabilities() != null) {
            for (Symbol cap : source.getCapabilities()) {
                if (!symbol.equals(cap)) continue;
                return true;
            }
        }
        return false;
    }
}

