/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.quorum.zookeeper;

import org.apache.activemq.artemis.quorum.MutableLong;
import org.apache.activemq.artemis.quorum.UnavailableStateException;
import org.apache.activemq.artemis.quorum.zookeeper.CuratorDistributedPrimitive;
import org.apache.activemq.artemis.quorum.zookeeper.CuratorDistributedPrimitiveManager;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;

final class CuratorMutableLong
extends CuratorDistributedPrimitive
implements MutableLong {
    private final DistributedAtomicLong atomicLong;

    CuratorMutableLong(CuratorDistributedPrimitiveManager.PrimitiveId id, CuratorDistributedPrimitiveManager manager, DistributedAtomicLong atomicLong) {
        super(id, manager);
        this.atomicLong = atomicLong;
    }

    public String getMutableLongId() {
        return this.getId().id;
    }

    public long get() throws UnavailableStateException {
        return this.run(() -> {
            this.checkUnavailable();
            try {
                AtomicValue atomicValue = this.atomicLong.get();
                if (!atomicValue.succeeded()) {
                    throw new UnavailableStateException("cannot query long " + this.getId());
                }
                return (Long)atomicValue.postValue();
            }
            catch (Throwable e) {
                throw new UnavailableStateException(e);
            }
        });
    }

    public void set(long value) throws UnavailableStateException {
        this.run(() -> {
            this.checkUnavailable();
            try {
                this.atomicLong.forceSet(Long.valueOf(value));
                return null;
            }
            catch (Throwable e) {
                throw new UnavailableStateException(e);
            }
        });
    }
}

