/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.quorum.file;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import org.apache.activemq.artemis.quorum.DistributedLock;

final class FileDistributedLock
implements DistributedLock {
    private final String lockId;
    private final Consumer<String> onClosedLock;
    private boolean closed;
    private FileLock fileLock;
    private final FileChannel channel;

    FileDistributedLock(Consumer<String> onClosedLock, File locksFolder, String lockId) throws IOException {
        this.onClosedLock = onClosedLock;
        this.lockId = lockId;
        this.closed = false;
        this.fileLock = null;
        this.channel = FileChannel.open(new File(locksFolder, lockId).toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("This lock is closed");
        }
    }

    public String getLockId() {
        this.checkNotClosed();
        return this.lockId;
    }

    public boolean isHeldByCaller() {
        this.checkNotClosed();
        FileLock fileLock = this.fileLock;
        if (fileLock == null) {
            return false;
        }
        return fileLock.isValid();
    }

    public boolean tryLock() {
        FileLock lock;
        this.checkNotClosed();
        FileLock fileLock = this.fileLock;
        if (fileLock != null) {
            throw new IllegalStateException("unlock first");
        }
        try {
            lock = this.channel.tryLock();
        }
        catch (OverlappingFileLockException o) {
            return false;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
        if (lock == null) {
            return false;
        }
        this.fileLock = lock;
        return true;
    }

    public void unlock() {
        this.checkNotClosed();
        FileLock fileLock = this.fileLock;
        if (fileLock != null) {
            this.fileLock = null;
            try {
                fileLock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addListener(DistributedLock.UnavailableLockListener listener) {
        this.checkNotClosed();
    }

    public void removeListener(DistributedLock.UnavailableLockListener listener) {
        this.checkNotClosed();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close(boolean useCallback) {
        if (this.closed) {
            return;
        }
        try {
            if (useCallback) {
                this.onClosedLock.accept(this.lockId);
            }
            this.unlock();
            this.channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.closed = true;
        }
    }

    public void close() {
        this.close(true);
    }

    public FileChannel getChannel() {
        return this.channel;
    }
}

