package org.apache.activemq.artemis.ra;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import javax.jms.JMSException;
import java.util.Arrays;
import javax.resource.NotSupportedException;
import java.lang.Exception;
import java.lang.IllegalArgumentException;
import javax.jms.JMSRuntimeException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2022-06-07T13:00:47-0400")
public class ActiveMQRABundle_$bundle implements ActiveMQRABundle, Serializable {
    private static final long serialVersionUID = 1L;
    protected ActiveMQRABundle_$bundle() {}
    public static final ActiveMQRABundle_$bundle INSTANCE = new ActiveMQRABundle_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String errorDecodingPassword$str() {
        return "AMQ159000: Error decoding password using codec instance";
    }
    @Override
    public final ActiveMQIllegalStateException errorDecodingPassword(final Exception e) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), errorDecodingPassword$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String noActivationSpec$str() {
        return "AMQ159001: MDB cannot be deployed as it has no Activation Spec. Please provide an Activation!";
    }
    @Override
    public final NotSupportedException noActivationSpec() {
        final NotSupportedException result = new NotSupportedException(String.format(getLoggingLocale(), noActivationSpec$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDestinationName$str() {
        return "AMQ159002: Please provide a destination for the MDB";
    }
    @Override
    public final IllegalArgumentException noDestinationName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noDestinationName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalJEEMethod$str() {
        return "AMQ159003: This method is not applicable inside the application server. See the JEE spec, e.g. JEE 7 Section 6.7";
    }
    @Override
    public final JMSRuntimeException illegalJEEMethod() {
        final JMSRuntimeException result = new JMSRuntimeException(String.format(getLoggingLocale(), illegalJEEMethod$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSessionTransactedModeRuntime$str() {
        return "AMQ159004: Invalid Session Mode SESSION_TRANSACTED";
    }
    @Override
    public final JMSRuntimeException invalidSessionTransactedModeRuntime() {
        final JMSRuntimeException result = new JMSRuntimeException(String.format(getLoggingLocale(), invalidSessionTransactedModeRuntime$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidClientAcknowledgeModeRuntime$str() {
        return "AMQ159005: Invalid Session Mode CLIENT_ACKNOWLEDGE";
    }
    @Override
    public final JMSRuntimeException invalidClientAcknowledgeModeRuntime() {
        final JMSRuntimeException result = new JMSRuntimeException(String.format(getLoggingLocale(), invalidClientAcknowledgeModeRuntime$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAcknowledgeMode$str() {
        return "AMQ159006: Invalid Session Mode {0}";
    }
    @Override
    public final JMSRuntimeException invalidAcknowledgeMode(final int sessionMode) {
        final JMSRuntimeException result = new JMSRuntimeException(_formatMessage(invalidAcknowledgeMode$str(), sessionMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String invalidSessionTransactedModeRuntimeAllowLocal$str() {
        return "AMQ159007: Invalid Session Mode SESSION_TRANSACTED, to enable Local Transacted Sessions you can set the allowLocalTransactions (allow-local-transactions) on the resource adapter";
    }
    @Override
    public final JMSException invalidSessionTransactedModeRuntimeAllowLocal() {
        final JMSException result = new JMSException(String.format(getLoggingLocale(), invalidSessionTransactedModeRuntimeAllowLocal$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
