package org.apache.activemq.artemis.ra;

import java.util.Locale;
import javax.jms.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import java.util.Arrays;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-06-07T13:00:47-0400")
public class ActiveMQRALogger_$logger extends DelegatingBasicLogger implements ActiveMQRALogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQRALogger_$logger.class.getName();
    public ActiveMQRALogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void awaitingTopicQueueCreation(final String destination) {
        super.log.logv(FQCN, INFO, null, awaitingTopicQueueCreation$str(), destination);
    }
    protected String awaitingTopicQueueCreation$str() {
        return "AMQ151000: awaiting topic/queue creation {0}";
    }
    @Override
    public final void attemptingReconnect(final ActiveMQActivationSpec spec) {
        super.log.logv(FQCN, INFO, null, attemptingReconnect$str(), spec);
    }
    protected String attemptingReconnect$str() {
        return "AMQ151001: Attempting to reconnect {0}";
    }
    @Override
    public final void reconnected() {
        super.log.logv(FQCN, INFO, null, reconnected$str());
    }
    protected String reconnected$str() {
        return "AMQ151002: Reconnected with broker";
    }
    @Override
    public final void raStopped() {
        super.log.logv(FQCN, INFO, null, raStopped$str());
    }
    protected String raStopped$str() {
        return "AMQ151003: resource adaptor stopped";
    }
    @Override
    public final void instantiatingDestination(final String destinationType, final String destination) {
        super.log.logv(FQCN, INFO, null, instantiatingDestination$str(), destinationType, destination);
    }
    protected String instantiatingDestination$str() {
        return "AMQ151004: Instantiating {0} \"{1}\" directly since UseJNDI=false.";
    }
    @Override
    public final void awaitingJMSServerCreation() {
        super.log.logv(FQCN, INFO, null, awaitingJMSServerCreation$str());
    }
    protected String awaitingJMSServerCreation$str() {
        return "AMQ151005: awaiting server availability";
    }
    @Override
    public final void rebalancingConnections(final String event) {
        super.log.logv(FQCN, INFO, null, rebalancingConnections$str(), event);
    }
    protected String rebalancingConnections$str() {
        return "AMQ151006: Cluster topology change detected. Re-balancing connections on even {0}.";
    }
    @Override
    public final void resourceAdaptorStarted() {
        super.log.logv(FQCN, INFO, null, resourceAdaptorStarted$str());
    }
    protected String resourceAdaptorStarted$str() {
        return "AMQ151007: Resource adaptor started";
    }
    @Override
    public final void problemResettingXASession(final Throwable t) {
        super.log.logv(FQCN, WARN, t, problemResettingXASession$str());
    }
    protected String problemResettingXASession$str() {
        return "AMQ152001: problem resetting xa session after failure";
    }
    @Override
    public final void unableToRollbackTX() {
        super.log.logv(FQCN, WARN, null, unableToRollbackTX$str());
    }
    protected String unableToRollbackTX$str() {
        return "AMQ152002: Unable to roll local transaction back";
    }
    @Override
    public final void unableToResetSession(final String spec, final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToResetSession$str(), spec);
    }
    protected String unableToResetSession$str() {
        return "AMQ152003: unable to reset session after failure, we will place the MDB Inflow now in setup mode for activation={0}";
    }
    @Override
    public final void handlingJMSFailure(final Exception e) {
        super.log.logv(FQCN, WARN, e, handlingJMSFailure$str());
    }
    protected String handlingJMSFailure$str() {
        return "AMQ152004: Handling JMS exception failure";
    }
    @Override
    public final void failureInActivation(final Throwable t, final ActiveMQActivationSpec spec) {
        super.log.logv(FQCN, WARN, t, failureInActivation$str(), spec);
    }
    protected String failureInActivation$str() {
        return "AMQ152005: Failure in broker activation {0}";
    }
    @Override
    public final void unableToCallAfterDelivery(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToCallAfterDelivery$str());
    }
    protected String unableToCallAfterDelivery$str() {
        return "AMQ152006: Unable to call after delivery";
    }
    @Override
    public final void threadCouldNotFinish(final String thread) {
        super.log.logv(FQCN, WARN, null, threadCouldNotFinish$str(), thread);
    }
    protected String threadCouldNotFinish$str() {
        return "AMQ152007: Thread {0} could not be finished";
    }
    @Override
    public final void errorInterruptingHandler(final String endpoint, final String handler, final Throwable cause) {
        super.log.logv(FQCN, WARN, cause, errorInterruptingHandler$str(), endpoint, handler);
    }
    protected String errorInterruptingHandler$str() {
        return "AMQ152008: Error interrupting handler on endpoint {0} handler = {1}";
    }
    @Override
    public final void unableToValidateProperties(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToValidateProperties$str());
    }
    protected String unableToValidateProperties$str() {
        return "AMQ152009: Unable to validate properties";
    }
    @Override
    public final void unableToClearTheTransaction(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToClearTheTransaction$str());
    }
    protected String unableToClearTheTransaction$str() {
        return "AMQ152010: Unable to clear the transaction";
    }
    @Override
    public final void unableToCloseFactory(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToCloseFactory$str());
    }
    protected String unableToCloseFactory$str() {
        return "AMQ152011: Unable to close the factory";
    }
    @Override
    public final void errorCreatingReference(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorCreatingReference$str());
    }
    protected String errorCreatingReference$str() {
        return "AMQ154000: Error while creating object Reference.";
    }
    @Override
    public final void errorStoppingRA(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorStoppingRA$str());
    }
    protected String errorStoppingRA$str() {
        return "AMQ154001: Unable to stop resource adapter.";
    }
    @Override
    public final void errorReconnecting(final Throwable t, final ActiveMQActivationSpec spec) {
        super.log.logv(FQCN, ERROR, t, errorReconnecting$str(), spec);
    }
    protected String errorReconnecting$str() {
        return "AMQ154003: Unable to reconnect {0}";
    }
    @Override
    public final void errorDeliveringMessage(final Throwable t) {
        super.log.logv(FQCN, ERROR, t, errorDeliveringMessage$str());
    }
    protected String errorDeliveringMessage$str() {
        return "AMQ154004: Failed to deliver message";
    }
    @Override
    public final void warnDifferentConnectionfactory() {
        super.log.logv(FQCN, DEBUG, null, warnDifferentConnectionfactory$str());
    }
    protected String warnDifferentConnectionfactory$str() {
        return "AMQ153001: using different ActiveMQRAConnectionFactory";
    }
    protected String canNotCreatedNonSharedSubscriber$str() {
        return "AMQ153002: Cannot create a subscriber on the durable subscription since it already has subscriber(s)";
    }
    @Override
    public final IllegalStateException canNotCreatedNonSharedSubscriber() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), canNotCreatedNonSharedSubscriber$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void invalidAcknowledgementMode(final String mode) {
        super.log.logv(FQCN, WARN, null, invalidAcknowledgementMode$str(), mode);
    }
    protected String invalidAcknowledgementMode$str() {
        return "AMQ153003: Unsupported acknowledgement mode {0}";
    }
    @Override
    public final void invalidNumberOfMaxSession(final int value, final int defaultValue) {
        super.log.logv(FQCN, WARN, null, invalidNumberOfMaxSession$str(), value, defaultValue);
    }
    protected String invalidNumberOfMaxSession$str() {
        return "AMQ153004: Invalid number of session (negative) {0}, defaulting to {1}.";
    }
    @Override
    public final void unableToRetrieveDestinationName(final String destinationName, final String name, final String calculatedDestinationName) {
        super.log.logv(FQCN, WARN, null, unableToRetrieveDestinationName$str(), destinationName, name, calculatedDestinationName);
    }
    protected String unableToRetrieveDestinationName$str() {
        return "AMQ153005: Unable to retrieve \"{0}\" from JNDI. Creating a new \"{1}\" named \"{2}\" to be used by the MDB.";
    }
}
