/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import javax.jms.Connection;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.QueueConnection;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAJMSContext;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRASessionFactoryImpl;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.referenceable.ActiveMQRAConnectionFactoryObjectFactory;
import org.apache.activemq.artemis.ra.referenceable.SerializableObjectRefAddr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAConnectionFactoryImpl
implements ActiveMQRAConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final long serialVersionUID = 7981708919479859360L;
    private final ActiveMQRAManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;

    public ActiveMQRAConnectionFactoryImpl(ActiveMQRAManagedConnectionFactory mcf, ConnectionManager cm) {
        logger.trace("constructor({}, {})", (Object)mcf, (Object)cm);
        this.mcf = mcf;
        if (cm == null) {
            this.cm = new ActiveMQRAConnectionManager();
            logger.trace("Created new ConnectionManager={}", (Object)this.cm);
        } else {
            this.cm = cm;
        }
        logger.trace("Using ManagedConnectionFactory={}, ConnectionManager={}", (Object)mcf, (Object)cm);
    }

    public void setReference(Reference reference) {
        logger.trace("setReference({})", (Object)reference);
        this.reference = reference;
    }

    public Reference getReference() {
        logger.trace("getReference()");
        if (this.reference == null) {
            try {
                this.reference = new Reference(this.getClass().getCanonicalName(), new SerializableObjectRefAddr("ActiveMQ-CF", this), ActiveMQRAConnectionFactoryObjectFactory.class.getCanonicalName(), null);
            }
            catch (NamingException e) {
                ActiveMQRALogger.LOGGER.errorCreatingReference(e);
            }
        }
        return this.reference;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        logger.trace("createQueueConnection()");
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 1);
        logger.trace("Created queue connection: {}", (Object)s);
        return s;
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        logger.trace("createQueueConnection({}, ****)", (Object)userName);
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 1);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        logger.trace("Created queue connection: {}", (Object)s);
        return s;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        logger.trace("createTopicConnection()");
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 2);
        logger.trace("Created topic connection: {}", (Object)s);
        return s;
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        logger.trace("createTopicConnection({}, ****)", (Object)userName);
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 2);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        logger.trace("Created topic connection: {}", (Object)s);
        return s;
    }

    public Connection createConnection() throws JMSException {
        logger.trace("createConnection()");
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 0);
        logger.trace("Created connection: {}", (Object)s);
        return s;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        logger.trace("createConnection({}, ****)", (Object)userName);
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 0);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        logger.trace("Created connection: {}", (Object)s);
        return s;
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        logger.trace("createXAQueueConnection()");
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 4);
        logger.trace("Created queue connection: {}", (Object)s);
        return s;
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        logger.trace("createXAQueueConnection({}, ****)", (Object)userName);
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 4);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        logger.trace("Created queue connection: {}", (Object)s);
        return s;
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        logger.trace("createXATopicConnection()");
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 5);
        logger.trace("Created topic connection: {}", (Object)s);
        return s;
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        logger.trace("createXATopicConnection({}, ****)", (Object)userName);
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 5);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        logger.trace("Created topic connection: {}", (Object)s);
        return s;
    }

    public XAConnection createXAConnection() throws JMSException {
        logger.trace("createXAConnection()");
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 3);
        logger.trace("Created connection: {}", (Object)s);
        return s;
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        logger.trace("createXAConnection({}, ****)", (Object)userName);
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 3);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        logger.trace("Created connection: {}", (Object)s);
        return s;
    }

    public JMSContext createContext() {
        return this.createContext(null, null);
    }

    public JMSContext createContext(String userName, String password) {
        return this.createContext(userName, password, 1);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        ActiveMQRASessionFactoryImpl conn = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 0);
        conn.setUserName(userName);
        conn.setPassword(password);
        try {
            this.validateUser(conn);
        }
        catch (JMSSecurityException e) {
            JMSSecurityRuntimeException e2 = new JMSSecurityRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        return conn.createContext(sessionMode);
    }

    public JMSContext createContext(int sessionMode) {
        return this.createContext(null, null, sessionMode);
    }

    public XAJMSContext createXAContext() {
        return this.createXAContext(null, null);
    }

    public XAJMSContext createXAContext(String userName, String password) {
        ActiveMQRASessionFactoryImpl conn = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 3);
        conn.setUserName(userName);
        conn.setPassword(password);
        try {
            this.validateUser(conn);
        }
        catch (JMSSecurityException e) {
            JMSSecurityRuntimeException e2 = new JMSSecurityRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        return conn.createXAContext();
    }

    private void validateUser(ActiveMQRASessionFactoryImpl s) throws JMSException {
        Session session = s.createSession();
        session.close();
    }

    @Override
    public ActiveMQConnectionFactory getDefaultFactory() throws ResourceException {
        return ((ActiveMQResourceAdapter)this.mcf.getResourceAdapter()).getDefaultActiveMQConnectionFactory();
    }

    @Override
    public ActiveMQResourceAdapter getResourceAdapter() {
        return (ActiveMQResourceAdapter)this.mcf.getResourceAdapter();
    }
}

