/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.lang.invoke.MethodHandles;
import javax.resource.spi.ConnectionRequestInfo;
import org.apache.activemq.artemis.ra.ActiveMQRAProperties;
import org.apache.activemq.artemis.ra.ActiveMQRaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAConnectionRequestInfo
implements ConnectionRequestInfo {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String userName;
    private String password;
    private String clientID;
    private final int type;
    private final boolean transacted;
    private final int acknowledgeMode;

    public ActiveMQRAConnectionRequestInfo(ActiveMQRAProperties prop, int type) {
        logger.trace("constructor({})", (Object)prop);
        this.userName = prop.getUserName();
        this.password = prop.getPassword();
        this.clientID = prop.getClientID();
        this.type = type;
        this.transacted = true;
        this.acknowledgeMode = 1;
    }

    public ActiveMQRAConnectionRequestInfo(boolean transacted, int acknowledgeMode, int type) {
        if (logger.isTraceEnabled()) {
            logger.trace("constructor({}, {}, {})", new Object[]{transacted, acknowledgeMode, type});
        }
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.type = type;
    }

    public void setDefaults(ActiveMQRAProperties prop) {
        logger.trace("setDefaults({})", (Object)prop);
        if (this.userName == null) {
            this.userName = prop.getUserName();
        }
        if (this.password == null) {
            this.password = prop.getPassword();
        }
        if (this.clientID == null) {
            this.clientID = prop.getClientID();
        }
    }

    public String getUserName() {
        logger.trace("getUserName()");
        return this.userName;
    }

    public void setUserName(String userName) {
        logger.trace("setUserName({})", (Object)userName);
        this.userName = userName;
    }

    public String getPassword() {
        logger.trace("getPassword()");
        return this.password;
    }

    public void setPassword(String password) {
        logger.trace("setPassword(****)");
        this.password = password;
    }

    public String getClientID() {
        logger.trace("getClientID()");
        return this.clientID;
    }

    public void setClientID(String clientID) {
        logger.trace("setClientID({})", (Object)clientID);
        this.clientID = clientID;
    }

    public int getType() {
        logger.trace("getType()");
        return this.type;
    }

    public boolean isTransacted() {
        if (logger.isTraceEnabled()) {
            logger.trace("isTransacted() {}", (Object)this.transacted);
        }
        return this.transacted;
    }

    public int getAcknowledgeMode() {
        logger.trace("getAcknowledgeMode()");
        return this.acknowledgeMode;
    }

    public boolean equals(Object obj) {
        logger.trace("equals({})", obj);
        if (obj == null) {
            return false;
        }
        if (obj instanceof ActiveMQRAConnectionRequestInfo) {
            ActiveMQRAConnectionRequestInfo you = (ActiveMQRAConnectionRequestInfo)obj;
            return ActiveMQRaUtils.compare(this.userName, you.getUserName()) && ActiveMQRaUtils.compare(this.password, you.getPassword()) && ActiveMQRaUtils.compare(this.clientID, you.getClientID()) && this.type == you.getType() && this.transacted == you.isTransacted() && this.acknowledgeMode == you.getAcknowledgeMode();
        }
        return false;
    }

    public int hashCode() {
        logger.trace("hashCode()");
        int hash = 7;
        hash += 31 * hash + (this.userName != null ? this.userName.hashCode() : 0);
        hash += 31 * hash + (this.password != null ? this.password.hashCode() : 0);
        hash += 31 * hash + Integer.valueOf(this.type).hashCode();
        hash += 31 * hash + (this.transacted ? 1 : 0);
        hash += 31 * hash + Integer.valueOf(this.acknowledgeMode).hashCode();
        return hash;
    }

    public String toString() {
        return "ActiveMQRAConnectionRequestInfo[type=" + this.type + ", transacted=" + this.transacted + ", acknowledgeMode=" + this.acknowledgeMode + ", clientID=" + this.clientID + ", userName=" + this.userName + ", password=****]";
    }
}

