/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.osgi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.osgi.ActiveMQOsgiLogger;
import org.apache.activemq.artemis.osgi.ServerTrackerCallBack;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ProtocolTracker
implements ServiceTrackerCustomizer<ProtocolManagerFactory<Interceptor>, ProtocolManagerFactory<Interceptor>> {
    private String name;
    private BundleContext context;
    private Map<String, Boolean> protocols;
    private ServerTrackerCallBack callback;

    public ProtocolTracker(String name, BundleContext context, String[] requiredProtocols, ServerTrackerCallBack callback) {
        this.name = name;
        this.context = context;
        this.callback = callback;
        this.protocols = new HashMap<String, Boolean>();
        for (String requiredProtocol : requiredProtocols) {
            this.protocols.put(requiredProtocol, false);
        }
        ActiveMQOsgiLogger.LOGGER.brokerConfigFound(name, Arrays.asList(requiredProtocols).toString());
        this.protocols.put("CORE", true);
        List<String> missing = this.getMissing();
        if (missing.isEmpty()) {
            try {
                callback.start();
            }
            catch (Exception e) {
                ActiveMQOsgiLogger.LOGGER.errorStartingBroker(name, e);
            }
        }
    }

    public ProtocolManagerFactory addingService(ServiceReference<ProtocolManagerFactory<Interceptor>> reference) {
        ProtocolManagerFactory pmf = (ProtocolManagerFactory)this.context.getService(reference);
        this.callback.addFactory((ProtocolManagerFactory<Interceptor>)pmf);
        for (String protocol : pmf.getProtocols()) {
            this.protocolAdded(protocol);
        }
        return pmf;
    }

    public void modifiedService(ServiceReference<ProtocolManagerFactory<Interceptor>> reference, ProtocolManagerFactory<Interceptor> pmf) {
    }

    public void removedService(ServiceReference<ProtocolManagerFactory<Interceptor>> reference, ProtocolManagerFactory<Interceptor> pmf) {
        for (String protocol : pmf.getProtocols()) {
            this.protocolRemoved(protocol);
        }
        this.callback.removeFactory(pmf);
    }

    private void protocolAdded(String protocol) {
        Boolean present = this.protocols.get(protocol);
        if (present != null && !present.booleanValue()) {
            this.protocols.put(protocol, true);
            List<String> missing = this.getMissing();
            ActiveMQOsgiLogger.LOGGER.protocolWasAddedForBroker(protocol, this.name, (String)(missing.isEmpty() ? "Starting broker." : "Still waiting for " + missing));
            if (missing.isEmpty()) {
                try {
                    this.callback.start();
                }
                catch (Exception e) {
                    ActiveMQOsgiLogger.LOGGER.errorStartingBroker(this.name, e);
                }
            }
        }
    }

    private void protocolRemoved(String protocol) {
        Boolean present = this.protocols.get(protocol);
        if (present != null && present.booleanValue()) {
            List<String> missing = this.getMissing();
            ActiveMQOsgiLogger.LOGGER.protocolWasRemovedForBroker(protocol, this.name, missing.isEmpty() ? "Stopping broker. " : "");
            if (missing.isEmpty()) {
                try {
                    this.callback.stop();
                }
                catch (Exception e) {
                    ActiveMQOsgiLogger.LOGGER.errorStoppingBroker(this.name, e);
                }
            }
            this.protocols.put(protocol, false);
        }
    }

    private List<String> getMissing() {
        ArrayList<String> missing = new ArrayList<String>();
        for (String protocol : this.protocols.keySet()) {
            Boolean present = this.protocols.get(protocol);
            if (present.booleanValue()) continue;
            missing.add(protocol);
        }
        return missing;
    }
}

