/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.utils.MemorySize;

public class MessageReferenceImpl
implements MessageReference {
    private final AtomicInteger deliveryCount = new AtomicInteger();
    private volatile int persistedCount;
    private volatile long scheduledDeliveryTime;
    private final ServerMessage message;
    private final Queue queue;
    private Long consumerID;
    private boolean alreadyAcked;
    private static final int memoryOffset = MemorySize.is64bitArch() ? 48 : 32;

    public MessageReferenceImpl() {
        this.queue = null;
        this.message = null;
    }

    public MessageReferenceImpl(MessageReferenceImpl other, Queue queue) {
        this.deliveryCount.set(other.deliveryCount.get());
        this.scheduledDeliveryTime = other.scheduledDeliveryTime;
        this.message = other.message;
        this.queue = queue;
    }

    protected MessageReferenceImpl(ServerMessage message, Queue queue) {
        this.message = message;
        this.queue = queue;
    }

    @Override
    public int getPersistedCount() {
        return this.persistedCount;
    }

    @Override
    public void setPersistedCount(int persistedCount) {
        this.persistedCount = persistedCount;
    }

    @Override
    public MessageReference copy(Queue queue) {
        return new MessageReferenceImpl(this, queue);
    }

    public static int getMemoryEstimate() {
        return memoryOffset;
    }

    @Override
    public int getDeliveryCount() {
        return this.deliveryCount.get();
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount.set(deliveryCount);
        this.persistedCount = this.deliveryCount.get();
    }

    @Override
    public void incrementDeliveryCount() {
        this.deliveryCount.incrementAndGet();
    }

    @Override
    public void decrementDeliveryCount() {
        this.deliveryCount.decrementAndGet();
    }

    @Override
    public long getScheduledDeliveryTime() {
        return this.scheduledDeliveryTime;
    }

    @Override
    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        this.scheduledDeliveryTime = scheduledDeliveryTime;
    }

    @Override
    public ServerMessage getMessage() {
        return this.message;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public void handled() {
        this.queue.referenceHandled();
    }

    @Override
    public void setAlreadyAcked() {
        this.alreadyAcked = true;
    }

    @Override
    public boolean isAlreadyAcked() {
        return this.alreadyAcked;
    }

    @Override
    public boolean isPaged() {
        return false;
    }

    @Override
    public void acknowledge() throws Exception {
        this.queue.acknowledge(this);
    }

    @Override
    public void setConsumerId(Long consumerID) {
        this.consumerID = consumerID;
    }

    @Override
    public Long getConsumerId() {
        return this.consumerID;
    }

    @Override
    public int getMessageMemoryEstimate() {
        return this.message.getMemoryEstimate();
    }

    public String toString() {
        return "Reference[" + this.getMessage().getMessageID() + "]:" + (this.getMessage().isDurable() ? "RELIABLE" : "NON-RELIABLE") + ":" + this.getMessage();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MessageReferenceImpl) {
            MessageReferenceImpl reference = (MessageReferenceImpl)other;
            if (this.getMessage().equals(reference.getMessage())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getMessage().hashCode();
    }
}

