/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.core.settings.Mergeable;
import org.apache.activemq.artemis.core.settings.impl.Match;

public class HierarchicalObjectRepository<T>
implements HierarchicalRepository<T> {
    private boolean listenersEnabled = true;
    private T defaultmatch;
    private final Map<String, Match<T>> matches = new HashMap<String, Match<T>>();
    private final Set<String> immutables = new HashSet<String>();
    private final MatchComparator matchComparator = new MatchComparator();
    private final Map<String, T> cache = new ConcurrentHashMap<String, T>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    private final ArrayList<HierarchicalRepositoryChangeListener> listeners = new ArrayList();

    @Override
    public void disableListeners() {
        this.lock.writeLock().lock();
        try {
            this.listenersEnabled = false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void enableListeners() {
        this.lock.writeLock().lock();
        try {
            this.listenersEnabled = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.onChange();
    }

    @Override
    public void addMatch(String match, T value) {
        this.addMatch(match, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> values() {
        this.lock.readLock().lock();
        try {
            ArrayList<T> values = new ArrayList<T>(this.matches.size());
            for (Match<T> matchValue : this.matches.values()) {
                values.add(matchValue.getValue());
            }
            ArrayList<T> arrayList = values;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMatch(String match, T value, boolean immutableMatch) {
        this.lock.writeLock().lock();
        try {
            this.clearCache();
            if (immutableMatch) {
                this.immutables.add(match);
            }
            Match.verify(match);
            Match<T> match1 = new Match<T>(match);
            match1.setValue(value);
            this.matches.put(match, match1);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.onChange();
    }

    @Override
    public int getCacheSize() {
        return this.cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getMatch(String match) {
        T cacheResult = this.cache.get(match);
        if (cacheResult != null) {
            return cacheResult;
        }
        this.lock.readLock().lock();
        try {
            T value;
            Map<String, Match<T>> possibleMatches = this.getPossibleMatches(match);
            List<Match<T>> orderedMatches = this.sort(possibleMatches);
            T actualMatch = this.merge(orderedMatches);
            T t = value = actualMatch != null ? actualMatch : this.defaultmatch;
            if (value != null) {
                this.cache.put(match, value);
            }
            T t2 = value;
            return t2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private T merge(Collection<Match<T>> orderedMatches) {
        Object actualMatch = null;
        for (Match<T> match : orderedMatches) {
            if (actualMatch == null || !Mergeable.class.isAssignableFrom(actualMatch.getClass())) {
                actualMatch = match.getValue();
                if (Mergeable.class.isAssignableFrom(actualMatch.getClass())) continue;
                break;
            }
            ((Mergeable)actualMatch).merge(match.getValue());
        }
        return (T)actualMatch;
    }

    private List<Match<T>> sort(Map<String, Match<T>> possibleMatches) {
        ArrayList<String> keys = new ArrayList<String>(possibleMatches.keySet());
        Collections.sort(keys, this.matchComparator);
        ArrayList<Match<T>> matches1 = new ArrayList<Match<T>>(possibleMatches.size());
        for (String key : keys) {
            matches1.add(possibleMatches.get(key));
        }
        return matches1;
    }

    @Override
    public void removeMatch(String match) {
        this.lock.writeLock().lock();
        try {
            boolean isImmutable = this.immutables.contains(match);
            if (isImmutable) {
                ActiveMQServerLogger.LOGGER.debug("Cannot remove match " + match + " since it came from a main config");
            } else {
                this.clearCache();
                this.matches.remove(match);
                this.onChange();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void registerListener(HierarchicalRepositoryChangeListener listener) {
        this.lock.writeLock().lock();
        try {
            this.listeners.add(listener);
            if (this.listenersEnabled) {
                listener.onChange();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void unRegisterListener(HierarchicalRepositoryChangeListener listener) {
        this.lock.writeLock().lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setDefault(T defaultValue) {
        this.clearCache();
        this.defaultmatch = defaultValue;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.clearCache();
            this.listeners.clear();
            this.matches.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChange() {
        this.lock.readLock().lock();
        try {
            if (this.listenersEnabled) {
                for (HierarchicalRepositoryChangeListener listener : this.listeners) {
                    try {
                        listener.onChange();
                    }
                    catch (Throwable e) {
                        ActiveMQServerLogger.LOGGER.errorCallingRepoListener(e);
                    }
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Map<String, Match<T>> getPossibleMatches(String match) {
        HashMap<String, Match<T>> possibleMatches = new HashMap<String, Match<T>>();
        for (Map.Entry<String, Match<T>> entry : this.matches.entrySet()) {
            Match<T> entryMatch = entry.getValue();
            if (!entryMatch.getPattern().matcher(match).matches()) continue;
            possibleMatches.put(entry.getKey(), entryMatch);
        }
        return possibleMatches;
    }

    private static final class MatchComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -6182535107518999740L;

        private MatchComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.contains("#") && !o2.contains("#")) {
                return 1;
            }
            if (!o1.contains("#") && o2.contains("#")) {
                return -1;
            }
            if (o1.contains("#") && o2.contains("#")) {
                return o2.length() - o1.length();
            }
            if (o1.contains("*") && !o2.contains("*")) {
                return 1;
            }
            if (!o1.contains("*") && o2.contains("*")) {
                return -1;
            }
            if (o1.contains("*") && o2.contains("*")) {
                String[] leftSplits = o1.split("\\.");
                String[] rightSplits = o2.split("\\.");
                for (int i = 0; i < leftSplits.length; ++i) {
                    String left = leftSplits[i];
                    if (!left.equals("*")) continue;
                    if (rightSplits.length < i || !rightSplits[i].equals("*")) {
                        return -1;
                    }
                    return 1;
                }
            }
            return o1.length() - o2.length();
        }
    }
}

