/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCursorProviderImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class PagingStoreFactoryNIO
implements PagingStoreFactory {
    private static final String ADDRESS_FILE = "address.txt";
    private final File directory;
    private final ExecutorFactory executorFactory;
    protected final boolean syncNonTransactional;
    private PagingManager pagingManager;
    private final ScheduledExecutorService scheduledExecutor;
    private final long syncTimeout;
    private final StorageManager storageManager;
    private final IOCriticalErrorListener critialErrorListener;

    public PagingStoreFactoryNIO(StorageManager storageManager, File directory, long syncTimeout, ScheduledExecutorService scheduledExecutor, ExecutorFactory executorFactory, boolean syncNonTransactional, IOCriticalErrorListener critialErrorListener) {
        this.storageManager = storageManager;
        this.directory = directory;
        this.executorFactory = executorFactory;
        this.syncNonTransactional = syncNonTransactional;
        this.scheduledExecutor = scheduledExecutor;
        this.syncTimeout = syncTimeout;
        this.critialErrorListener = critialErrorListener;
    }

    @Override
    public void stop() {
    }

    @Override
    public PageCursorProvider newCursorProvider(PagingStore store, StorageManager storageManager, AddressSettings addressSettings, Executor executor) {
        return new PageCursorProviderImpl(store, storageManager, executor, addressSettings.getPageCacheMaxSize());
    }

    @Override
    public synchronized PagingStore newStore(SimpleString address, AddressSettings settings) {
        return new PagingStoreImpl(address, this.scheduledExecutor, this.syncTimeout, this.pagingManager, this.storageManager, null, this, address, settings, this.executorFactory.getExecutor(), this.syncNonTransactional);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SequentialFileFactory newFileFactory(SimpleString address) throws Exception {
        String guid = UUIDGenerator.getInstance().generateStringUUID();
        SequentialFileFactory factory = this.newFileFactory(guid);
        factory.createDirs();
        File fileWithID = new File(this.directory, guid + File.separatorChar + ADDRESS_FILE);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileWithID)));){
            writer.write(address.toString());
            writer.newLine();
        }
        return factory;
    }

    @Override
    public void setPagingManager(PagingManager pagingManager) {
        this.pagingManager = pagingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PagingStore> reloadStores(HierarchicalRepository<AddressSettings> addressSettingsRepository) throws Exception {
        File[] files = this.directory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<PagingStore> storesReturn = new ArrayList<PagingStore>(files.length);
        for (File file : files) {
            String addressString;
            String guid = file.getName();
            File addressFile = new File(file, ADDRESS_FILE);
            if (!addressFile.exists()) {
                if (file.getName().contains("oldreplica.")) continue;
                ActiveMQServerLogger.LOGGER.pageStoreFactoryNoIdFile(file.toString(), ADDRESS_FILE);
                continue;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(addressFile)));){
                addressString = reader.readLine();
            }
            SimpleString address = new SimpleString(addressString);
            SequentialFileFactory factory = this.newFileFactory(guid);
            AddressSettings settings = addressSettingsRepository.getMatch(address.toString());
            PagingStoreImpl store = new PagingStoreImpl(address, this.scheduledExecutor, this.syncTimeout, this.pagingManager, this.storageManager, factory, this, address, settings, this.executorFactory.getExecutor(), this.syncNonTransactional);
            storesReturn.add(store);
        }
        return storesReturn;
    }

    private SequentialFileFactory newFileFactory(String directoryName) {
        return new NIOSequentialFileFactory(new File(this.directory, directoryName), false, this.critialErrorListener, 1);
    }
}

