/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.jboss.logging.Logger;

public class FileMoveManager {
    private static final Logger logger = Logger.getLogger(FileMoveManager.class);
    private final File folder;
    private int maxFolders;
    public static final String PREFIX = "oldreplica.";
    private static final FilenameFilter isPrefix = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            boolean prefixed = name.contains(FileMoveManager.PREFIX);
            if (prefixed) {
                try {
                    Integer.parseInt(name.substring(FileMoveManager.PREFIX.length()));
                }
                catch (NumberFormatException e) {
                    prefixed = false;
                }
            }
            return prefixed;
        }
    };
    private static final FilenameFilter notPrefix = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !isPrefix.accept(dir, name);
        }
    };

    public FileMoveManager(File folder) {
        this(folder, -1);
    }

    public FileMoveManager(File folder, int maxFolders) {
        this.folder = folder;
        this.maxFolders = maxFolders;
    }

    public int getMaxFolders() {
        return this.maxFolders;
    }

    public FileMoveManager setMaxFolders(int maxFolders) {
        this.maxFolders = maxFolders;
        return this;
    }

    public void doMove() throws IOException {
        String[] files = this.getFiles();
        if (files == null || files.length == 0) {
            return;
        }
        this.internalCheckOldFolders(1);
        int whereToMove = this.getMaxID() + 1;
        if (this.maxFolders == 0) {
            ActiveMQServerLogger.LOGGER.backupDeletingData(this.folder.getPath());
            for (String fileMove : files) {
                File fileFrom = new File(this.folder, fileMove);
                logger.tracef("deleting %s", (Object)fileFrom);
                this.deleteTree(fileFrom);
            }
        } else {
            File folderTo = this.getFolder(whereToMove);
            folderTo.mkdirs();
            ActiveMQServerLogger.LOGGER.backupMovingDataAway(this.folder.getPath(), folderTo.getPath());
            for (String fileMove : files) {
                File fileFrom = new File(this.folder, fileMove);
                File fileTo = new File(folderTo, fileMove);
                logger.tracef("doMove:: moving %s as %s", (Object)fileFrom, (Object)fileTo);
                Files.move(fileFrom.toPath(), fileTo.toPath(), new CopyOption[0]);
            }
        }
    }

    public void checkOldFolders() {
        this.internalCheckOldFolders(0);
    }

    private void internalCheckOldFolders(int creating) {
        if (this.maxFolders >= 0) {
            int folders = this.getNumberOfFolders();
            if (folders == 0) {
                return;
            }
            int foldersToDelete = folders + creating - this.maxFolders;
            if (foldersToDelete > 0) {
                logger.tracef("There are %d folders to delete", (Object)foldersToDelete);
                int[] ids = this.getIDlist();
                for (int i = 0; i < foldersToDelete; ++i) {
                    File file = this.getFolder(ids[i]);
                    ActiveMQServerLogger.LOGGER.removingBackupData(file.getPath());
                    this.deleteTree(file);
                }
            }
        }
    }

    public String[] getFiles() {
        return this.folder.list(notPrefix);
    }

    public int getNumberOfFolders() {
        return this.getFolders().length;
    }

    public String[] getFolders() {
        String[] list = this.folder.list(isPrefix);
        if (list == null) {
            list = new String[]{};
        }
        return list;
    }

    public int getMinID() {
        int[] list = this.getIDlist();
        if (list.length == 0) {
            return 0;
        }
        return list[0];
    }

    public int getMaxID() {
        int[] list = this.getIDlist();
        if (list.length == 0) {
            return 0;
        }
        return list[list.length - 1];
    }

    public int[] getIDlist() {
        String[] list = this.getFolders();
        int[] ids = new int[list.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.getID(list[i]);
        }
        Arrays.sort(ids);
        return ids;
    }

    public int getID(String folderName) {
        return Integer.parseInt(folderName.substring(PREFIX.length()));
    }

    public File getFolder(int id) {
        return new File(this.folder, PREFIX + id);
    }

    private void deleteTree(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File fileDelete : files) {
                this.deleteTree(fileDelete);
            }
        }
        file.delete();
    }
}

