/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.server.cluster.ha.BackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;

public class ReplicaPolicy
extends BackupPolicy {
    private String clusterName;
    private int maxSavedReplicatedJournalsSize = ActiveMQDefaultConfiguration.getDefaultMaxSavedReplicatedJournalsSize();
    private String groupName = null;
    private boolean restartBackup = ActiveMQDefaultConfiguration.isDefaultRestartBackup();
    private ReplicatedPolicy replicatedPolicy;

    public ReplicaPolicy() {
    }

    public ReplicaPolicy(String clusterName, int maxSavedReplicatedJournalsSize, String groupName, boolean restartBackup, boolean allowFailback, long failbackDelay, ScaleDownPolicy scaleDownPolicy) {
        this.clusterName = clusterName;
        this.maxSavedReplicatedJournalsSize = maxSavedReplicatedJournalsSize;
        this.groupName = groupName;
        this.restartBackup = restartBackup;
        this.scaleDownPolicy = scaleDownPolicy;
        this.replicatedPolicy = new ReplicatedPolicy(false, allowFailback, failbackDelay, groupName, clusterName, this);
    }

    public ReplicaPolicy(String clusterName, int maxSavedReplicatedJournalsSize, String groupName, ReplicatedPolicy replicatedPolicy) {
        this.clusterName = clusterName;
        this.maxSavedReplicatedJournalsSize = maxSavedReplicatedJournalsSize;
        this.groupName = groupName;
        this.replicatedPolicy = replicatedPolicy;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public int getMaxSavedReplicatedJournalsSize() {
        return this.maxSavedReplicatedJournalsSize;
    }

    public void setMaxSavedReplicatedJournalsSize(int maxSavedReplicatedJournalsSize) {
        this.maxSavedReplicatedJournalsSize = maxSavedReplicatedJournalsSize;
    }

    public ReplicatedPolicy getReplicatedPolicy() {
        return this.replicatedPolicy;
    }

    public void setReplicatedPolicy(ReplicatedPolicy replicatedPolicy) {
        this.replicatedPolicy = replicatedPolicy;
    }

    @Override
    public String getBackupGroupName() {
        return this.groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public boolean isRestartBackup() {
        return this.restartBackup;
    }

    @Override
    public void setRestartBackup(boolean restartBackup) {
        this.restartBackup = restartBackup;
    }

    @Override
    public boolean isSharedStore() {
        return false;
    }

    @Override
    public boolean canScaleDown() {
        return this.scaleDownPolicy != null;
    }

    @Override
    public Activation createActivation(ActiveMQServerImpl server, boolean wasLive, Map<String, Object> activationParams, ActiveMQServerImpl.ShutdownOnCriticalErrorListener shutdownOnCriticalIO) throws Exception {
        SharedNothingBackupActivation backupActivation = new SharedNothingBackupActivation(server, wasLive, activationParams, shutdownOnCriticalIO, this);
        backupActivation.init();
        return backupActivation;
    }
}

