/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;

public class LegacyLDAPSecuritySettingPlugin
implements SecuritySettingPlugin {
    private static final long serialVersionUID = 4793109879399750045L;
    public static final String INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    public static final String CONNECTION_URL = "connectionURL";
    public static final String CONNECTION_USERNAME = "connectionUsername";
    public static final String CONNECTION_PASSWORD = "connectionPassword";
    public static final String CONNECTION_PROTOCOL = "connectionProtocol";
    public static final String AUTHENTICATION = "authentication";
    public static final String ROLE_ATTRIBUTE = "roleAttribute";
    public static final String FILTER = "filter";
    public static final String DESTINATION_BASE = "destinationBase";
    public static final String ADMIN_PERMISSION_VALUE = "adminPermissionValue";
    public static final String READ_PERMISSION_VALUE = "readPermissionValue";
    public static final String WRITE_PERMISSION_VALUE = "writePermissionValue";
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String connectionURL = "ldap://localhost:1024";
    private String connectionUsername;
    private String connectionPassword;
    private String connectionProtocol;
    private String authentication = "simple";
    private String destinationBase = "ou=destinations,o=ActiveMQ,ou=system";
    private String filter = "(cn=*)";
    private String roleAttribute = "uniqueMember";
    private String adminPermissionValue = "admin";
    private String readPermissionValue = "read";
    private String writePermissionValue = "write";
    private DirContext context;
    private Map<String, Set<Role>> securityRoles = new HashMap<String, Set<Role>>();

    @Override
    public LegacyLDAPSecuritySettingPlugin init(Map<String, String> options) {
        if (options != null) {
            this.initialContextFactory = options.get(INITIAL_CONTEXT_FACTORY);
            this.connectionURL = options.get(CONNECTION_URL);
            this.connectionUsername = options.get(CONNECTION_USERNAME);
            this.connectionPassword = options.get(CONNECTION_PASSWORD);
            this.connectionProtocol = options.get(CONNECTION_PROTOCOL);
            this.authentication = options.get(AUTHENTICATION);
            this.destinationBase = options.get(DESTINATION_BASE);
            this.filter = options.get(FILTER);
            this.roleAttribute = options.get(ROLE_ATTRIBUTE);
            this.adminPermissionValue = options.get(ADMIN_PERMISSION_VALUE);
            this.readPermissionValue = options.get(READ_PERMISSION_VALUE);
            this.writePermissionValue = options.get(WRITE_PERMISSION_VALUE);
        }
        return this;
    }

    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    public SecuritySettingPlugin setRoleAttribute(String roleAttribute) {
        this.roleAttribute = roleAttribute;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public LegacyLDAPSecuritySettingPlugin setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getDestinationBase() {
        return this.destinationBase;
    }

    public LegacyLDAPSecuritySettingPlugin setDestinationBase(String destinationBase) {
        this.destinationBase = destinationBase;
        return this;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public LegacyLDAPSecuritySettingPlugin setAuthentication(String authentication) {
        this.authentication = authentication;
        return this;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
        return this;
    }

    public String getConnectionProtocol() {
        return this.connectionProtocol;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionProtocol(String connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
        return this;
    }

    public String getConnectionUsername() {
        return this.connectionUsername;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionUsername(String connectionUsername) {
        this.connectionUsername = connectionUsername;
        return this;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public String getAdminPermissionValue() {
        return this.adminPermissionValue;
    }

    public LegacyLDAPSecuritySettingPlugin setAdminPermissionValue(String adminPermissionValue) {
        this.adminPermissionValue = adminPermissionValue;
        return this;
    }

    public String getReadPermissionValue() {
        return this.readPermissionValue;
    }

    public LegacyLDAPSecuritySettingPlugin setReadPermissionValue(String readPermissionValue) {
        this.readPermissionValue = readPermissionValue;
        return this;
    }

    public String getWritePermissionValue() {
        return this.writePermissionValue;
    }

    public LegacyLDAPSecuritySettingPlugin setWritePermissionValue(String writePermissionValue) {
        this.writePermissionValue = writePermissionValue;
        return this;
    }

    public LegacyLDAPSecuritySettingPlugin setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
        return this;
    }

    protected void open() throws NamingException {
        if (this.context != null) {
            return;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.initialContextFactory);
        if (this.connectionUsername == null || "".equals(this.connectionUsername)) {
            throw new NamingException("Empty username is not allowed");
        }
        env.put("java.naming.security.principal", this.connectionUsername);
        if (this.connectionPassword == null || "".equals(this.connectionPassword)) {
            throw new NamingException("Empty password is not allowed");
        }
        env.put("java.naming.security.credentials", this.connectionPassword);
        env.put("java.naming.security.protocol", this.connectionProtocol);
        env.put("java.naming.provider.url", this.connectionURL);
        env.put("java.naming.security.authentication", this.authentication);
        this.context = new InitialDirContext(env);
    }

    @Override
    public Map<String, Set<Role>> getSecurityRoles() {
        return this.securityRoles;
    }

    @Override
    public LegacyLDAPSecuritySettingPlugin populateSecurityRoles() {
        ActiveMQServerLogger.LOGGER.populatingSecurityRolesFromLDAP(this.connectionURL);
        try {
            this.open();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorOpeningContextForLDAP(e);
            return this;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{this.roleAttribute});
        searchControls.setSearchScope(2);
        HashMap<String, Set<Role>> securityRoles = new HashMap<String, Set<Role>>();
        try {
            NamingEnumeration<SearchResult> searchResults = this.context.search(this.destinationBase, this.filter, searchControls);
            int i = 0;
            while (searchResults.hasMore()) {
                SearchResult searchResult = searchResults.next();
                Attributes attrs = searchResult.getAttributes();
                if (attrs == null || attrs.size() == 0) continue;
                LdapName searchResultLdapName = new LdapName(searchResult.getName());
                ActiveMQServerLogger.LOGGER.debug("LDAP search result " + ++i + ": " + searchResultLdapName);
                String permissionType = null;
                String destination = null;
                String destinationType = "unknown";
                for (Rdn rdn : searchResultLdapName.getRdns()) {
                    if (rdn.getType().equals("cn")) {
                        ActiveMQServerLogger.LOGGER.debug("\tPermission type: " + rdn.getValue());
                        permissionType = rdn.getValue().toString();
                    }
                    if (rdn.getType().equals("uid")) {
                        ActiveMQServerLogger.LOGGER.debug("\tDestination name: " + rdn.getValue());
                        destination = rdn.getValue().toString();
                    }
                    if (!rdn.getType().equals("ou")) continue;
                    String rawDestinationType = rdn.getValue().toString();
                    if (rawDestinationType.toLowerCase().contains("queue")) {
                        destinationType = "queue";
                    } else if (rawDestinationType.toLowerCase().contains("topic")) {
                        destinationType = "topic";
                    }
                    ActiveMQServerLogger.LOGGER.debug("\tDestination type: " + destinationType);
                }
                ActiveMQServerLogger.LOGGER.debug("\tAttributes: " + attrs);
                Attribute attr = attrs.get(this.roleAttribute);
                NamingEnumeration<?> e = attr.getAll();
                HashSet<Role> roles = (HashSet<Role>)securityRoles.get(destination);
                boolean exists = false;
                if (roles == null) {
                    roles = new HashSet<Role>();
                } else {
                    exists = true;
                }
                while (e.hasMore()) {
                    String value = (String)e.next();
                    LdapName ldapname = new LdapName(value);
                    Rdn rdn = ldapname.getRdn(ldapname.size() - 1);
                    String roleName = rdn.getValue().toString();
                    ActiveMQServerLogger.LOGGER.debug("\tRole name: " + roleName);
                    Role role = new Role(roleName, permissionType.equalsIgnoreCase(this.writePermissionValue), permissionType.equalsIgnoreCase(this.readPermissionValue), permissionType.equalsIgnoreCase(this.adminPermissionValue), permissionType.equalsIgnoreCase(this.adminPermissionValue), permissionType.equalsIgnoreCase(this.adminPermissionValue), permissionType.equalsIgnoreCase(this.adminPermissionValue), false);
                    roles.add(role);
                }
                if (exists) continue;
                securityRoles.put(destination, roles);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorPopulatingSecurityRolesFromLDAP(e);
        }
        this.securityRoles = securityRoles;
        return this;
    }
}

