/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ConnectorServiceFactory;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.cluster.Transformer;
import org.apache.activemq.artemis.spi.core.remoting.AcceptorFactory;
import org.apache.activemq.artemis.utils.ClassloadingUtil;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;
    private List<BaseInterceptor> incomingInterceptors = Collections.synchronizedList(new ArrayList());
    private List<BaseInterceptor> outgoingInterceptors = Collections.synchronizedList(new ArrayList());
    private Map<String, Transformer> divertTransformers;
    private Map<String, Transformer> bridgeTransformers;
    private Map<String, AcceptorFactory> acceptorFactories;
    private Map<String, Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>> connectorServices = new ConcurrentHashMap<String, Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>>();

    public ServiceRegistryImpl() {
        this.divertTransformers = new ConcurrentHashMap<String, Transformer>();
        this.bridgeTransformers = new ConcurrentHashMap<String, Transformer>();
        this.acceptorFactories = new ConcurrentHashMap<String, AcceptorFactory>();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public void addConnectorService(ConnectorServiceFactory connectorServiceFactory, ConnectorServiceConfiguration configuration) {
        this.connectorServices.put(configuration.getConnectorName(), (Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>)new Pair((Object)connectorServiceFactory, (Object)configuration));
    }

    @Override
    public void removeConnectorService(ConnectorServiceConfiguration configuration) {
        this.connectorServices.remove(configuration.getConnectorName());
    }

    @Override
    public Collection<Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>> getConnectorServices(List<ConnectorServiceConfiguration> configs) {
        if (configs != null) {
            for (final ConnectorServiceConfiguration config : configs) {
                if (this.connectorServices.get(config.getConnectorName()) != null) continue;
                ConnectorServiceFactory factory = AccessController.doPrivileged(new PrivilegedAction<ConnectorServiceFactory>(){

                    @Override
                    public ConnectorServiceFactory run() {
                        return (ConnectorServiceFactory)ClassloadingUtil.newInstanceFromClassLoader((String)config.getFactoryClassName());
                    }
                });
                this.addConnectorService(factory, config);
            }
        }
        return this.connectorServices.values();
    }

    @Override
    public void addIncomingInterceptor(BaseInterceptor interceptor) {
        this.incomingInterceptors.add(interceptor);
    }

    @Override
    public List<BaseInterceptor> getIncomingInterceptors(List<String> classNames) {
        ArrayList<BaseInterceptor> interceptors = new ArrayList<BaseInterceptor>(this.incomingInterceptors);
        this.instantiateInterceptors(classNames, interceptors);
        return interceptors;
    }

    @Override
    public void addOutgoingInterceptor(BaseInterceptor interceptor) {
        this.outgoingInterceptors.add(interceptor);
    }

    @Override
    public List<BaseInterceptor> getOutgoingInterceptors(List<String> classNames) {
        ArrayList<BaseInterceptor> interceptors = new ArrayList<BaseInterceptor>(this.outgoingInterceptors);
        this.instantiateInterceptors(classNames, interceptors);
        return interceptors;
    }

    @Override
    public void addDivertTransformer(String name, Transformer transformer) {
        this.divertTransformers.put(name, transformer);
    }

    @Override
    public Transformer getDivertTransformer(String name, String className) {
        Transformer transformer = this.divertTransformers.get(name);
        if (transformer == null && className != null) {
            transformer = this.instantiateTransformer(className);
            this.addDivertTransformer(name, transformer);
        }
        return transformer;
    }

    @Override
    public void addBridgeTransformer(String name, Transformer transformer) {
        this.bridgeTransformers.put(name, transformer);
    }

    @Override
    public Transformer getBridgeTransformer(String name, String className) {
        Transformer transformer = this.bridgeTransformers.get(name);
        if (transformer == null && className != null) {
            transformer = this.instantiateTransformer(className);
            this.addBridgeTransformer(name, transformer);
        }
        return transformer;
    }

    @Override
    public AcceptorFactory getAcceptorFactory(String name, final String className) {
        AcceptorFactory factory = this.acceptorFactories.get(name);
        if (factory == null && className != null) {
            factory = AccessController.doPrivileged(new PrivilegedAction<AcceptorFactory>(){

                @Override
                public AcceptorFactory run() {
                    return (AcceptorFactory)ClassloadingUtil.newInstanceFromClassLoader((String)className);
                }
            });
            this.addAcceptorFactory(name, factory);
        }
        return factory;
    }

    @Override
    public void addAcceptorFactory(String name, AcceptorFactory acceptorFactory) {
        this.acceptorFactories.put(name, acceptorFactory);
    }

    private Transformer instantiateTransformer(final String className) {
        Transformer transformer = null;
        if (className != null) {
            try {
                transformer = AccessController.doPrivileged(new PrivilegedAction<Transformer>(){

                    @Override
                    public Transformer run() {
                        return (Transformer)ClassloadingUtil.newInstanceFromClassLoader((String)className);
                    }
                });
            }
            catch (Exception e) {
                throw ActiveMQMessageBundle.BUNDLE.errorCreatingTransformerClass(e, className);
            }
        }
        return transformer;
    }

    private void instantiateInterceptors(List<String> classNames, List<BaseInterceptor> interceptors) {
        if (classNames != null) {
            for (final String className : classNames) {
                BaseInterceptor interceptor = AccessController.doPrivileged(new PrivilegedAction<BaseInterceptor>(){

                    @Override
                    public BaseInterceptor run() {
                        return (BaseInterceptor)ClassloadingUtil.newInstanceFromClassLoader((String)className);
                    }
                });
                interceptors.add(interceptor);
            }
        }
    }
}

