/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security;

import io.netty.channel.Channel;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager2;
import org.apache.activemq.artemis.spi.core.security.jaas.JaasCallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.utils.CertificateUtil;

public class ActiveMQJAASSecurityManager
implements ActiveMQSecurityManager2 {
    private final boolean trace = ActiveMQServerLogger.LOGGER.isTraceEnabled();
    private String configurationName;
    private SecurityConfiguration configuration;

    public ActiveMQJAASSecurityManager() {
    }

    public ActiveMQJAASSecurityManager(String configurationName) {
        this.configurationName = configurationName;
    }

    public ActiveMQJAASSecurityManager(String configurationName, SecurityConfiguration configuration) {
        this.configurationName = configurationName;
        this.configuration = configuration;
    }

    @Override
    public boolean validateUser(String user, String password) {
        return this.validateUser(user, password, null);
    }

    @Override
    public boolean validateUser(String user, String password, X509Certificate[] certificates) {
        try {
            this.getAuthenticatedSubject(user, password, certificates);
            return true;
        }
        catch (LoginException e) {
            ActiveMQServerLogger.LOGGER.debug("Couldn't validate user", e);
            return false;
        }
    }

    @Override
    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        throw new UnsupportedOperationException("Invoke validateUserAndRole(String, String, Set<Role>, CheckType, String, RemotingConnection) instead");
    }

    @Override
    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType, String address, RemotingConnection connection) {
        Subject localSubject;
        X509Certificate[] certificates = null;
        if (connection.getTransportConnection() instanceof NettyConnection) {
            certificates = CertificateUtil.getCertsFromChannel((Channel)((NettyConnection)connection.getTransportConnection()).getChannel());
        }
        try {
            localSubject = this.getAuthenticatedSubject(user, password, certificates);
        }
        catch (LoginException e) {
            ActiveMQServerLogger.LOGGER.debug("Couldn't validate user", e);
            return false;
        }
        boolean authorized = false;
        if (localSubject != null) {
            Set<RolePrincipal> rolesWithPermission = this.getPrincipalsInRole(checkType, roles);
            Set<RolePrincipal> rolesForSubject = localSubject.getPrincipals(RolePrincipal.class);
            if (rolesForSubject.size() > 0 && rolesWithPermission.size() > 0) {
                Iterator<RolePrincipal> rolesForSubjectIter = rolesForSubject.iterator();
                while (!authorized && rolesForSubjectIter.hasNext()) {
                    Iterator<RolePrincipal> rolesWithPermissionIter = rolesWithPermission.iterator();
                    Principal subjectRole = rolesForSubjectIter.next();
                    while (!authorized && rolesWithPermissionIter.hasNext()) {
                        Principal roleWithPermission = rolesWithPermissionIter.next();
                        authorized = subjectRole.equals(roleWithPermission);
                    }
                }
            }
            if (this.trace) {
                ActiveMQServerLogger.LOGGER.trace("user " + (authorized ? " is " : " is NOT ") + "authorized");
            }
        }
        return authorized;
    }

    private Subject getAuthenticatedSubject(String user, String password, X509Certificate[] certificates) throws LoginException {
        LoginContext lc = new LoginContext(this.configurationName, null, new JaasCallbackHandler(user, password, certificates), this.configuration);
        lc.login();
        return lc.getSubject();
    }

    private Set<RolePrincipal> getPrincipalsInRole(CheckType checkType, Set<Role> roles) {
        HashSet<RolePrincipal> principals = new HashSet<RolePrincipal>();
        for (Role role : roles) {
            if (!checkType.hasRole(role)) continue;
            principals.add(new RolePrincipal(role.getName()));
        }
        return principals;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setConfiguration(SecurityConfiguration configuration) {
        this.configuration = configuration;
    }

    public SecurityConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new SecurityConfiguration();
        }
        return this.configuration;
    }
}

