/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security;

import java.util.List;
import java.util.Set;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.User;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;

@Deprecated
public class ActiveMQSecurityManagerImpl
implements ActiveMQSecurityManager {
    private final SecurityConfiguration configuration;
    private ActiveMQServerLogger logger = ActiveMQServerLogger.LOGGER;

    public ActiveMQSecurityManagerImpl() {
        this.configuration = new SecurityConfiguration();
    }

    public ActiveMQSecurityManagerImpl(SecurityConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean validateUser(String username, String password) {
        if (username != null) {
            User user = this.configuration.getUser(username);
            return user != null && user.isValid(username, password);
        }
        if (username == null && password == null) {
            return this.configuration.getDefaultUser() != null;
        }
        this.logger.debug("Validating default user against a provided password.  This happens when username=null, password!=null");
        String defaultUsername = this.configuration.getDefaultUser();
        User defaultUser = this.configuration.getUser(defaultUsername);
        return defaultUser != null && defaultUser.isValid(defaultUsername, password);
    }

    @Override
    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        if (this.validateUser(user, password)) {
            String defaultUser = this.configuration.getDefaultUser();
            List<String> availableRoles = this.configuration.getRole(user == null ? defaultUser : user);
            if (availableRoles == null) {
                return false;
            }
            for (String availableRole : availableRoles) {
                if (roles == null) continue;
                for (Role role : roles) {
                    if (!role.getName().equals(availableRole) || !checkType.hasRole(role)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public SecurityConfiguration getConfiguration() {
        return this.configuration;
    }
}

