/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;

public abstract class CertificateLoginModule
extends PropertiesLoader
implements LoginModule {
    private CallbackHandler callbackHandler;
    private Subject subject;
    private X509Certificate[] certificates;
    private String username;
    private Set<String> roles;
    private Set<Principal> principals = new HashSet<Principal>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.init(options);
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CertificateCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " Unable to obtain client certificates.");
        }
        this.certificates = ((CertificateCallback)callbacks[0]).getCertificates();
        this.username = this.getUserNameForCertificates(this.certificates);
        if (this.username == null) {
            throw new FailedLoginException("No user for client certificate: " + this.getDistinguishedName(this.certificates));
        }
        this.roles = this.getUserRoles(this.username);
        if (this.debug) {
            ActiveMQServerLogger.LOGGER.debug("Certificate for user: " + this.username);
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.username));
        for (String role : this.roles) {
            this.principals.add(new RolePrincipal(role));
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        if (this.debug) {
            ActiveMQServerLogger.LOGGER.debug("commit");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            ActiveMQServerLogger.LOGGER.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            ActiveMQServerLogger.LOGGER.debug("logout");
        }
        return true;
    }

    private void clear() {
        this.roles.clear();
        this.certificates = null;
    }

    protected abstract String getUserNameForCertificates(X509Certificate[] var1) throws LoginException;

    protected abstract Set<String> getUserRoles(String var1) throws LoginException;

    protected String getDistinguishedName(X509Certificate[] certs) {
        if (certs != null && certs.length > 0 && certs[0] != null) {
            return certs[0].getSubjectDN().getName();
        }
        return null;
    }
}

