/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;

public class PropertiesLoginModule
extends PropertiesLoader
implements LoginModule {
    private static final String USER_FILE_PROP_NAME = "org.apache.activemq.jaas.properties.user";
    private static final String ROLE_FILE_PROP_NAME = "org.apache.activemq.jaas.properties.role";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Properties users;
    private Properties roles;
    private String user;
    private final Set<Principal> principals = new HashSet<Principal>();
    private boolean loginSucceeded;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.loginSucceeded = false;
        this.init(options);
        this.users = this.load(USER_FILE_PROP_NAME, "user", options).getProps();
        this.roles = this.load(ROLE_FILE_PROP_NAME, "role", options).getProps();
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if (this.user == null) {
            throw new FailedLoginException("user name is null");
        }
        String password = this.users.getProperty(this.user);
        if (password == null) {
            throw new FailedLoginException("User does exist");
        }
        if (!password.equals(new String(tmpPassword))) {
            throw new FailedLoginException("Password does not match");
        }
        this.loginSucceeded = true;
        if (this.debug) {
            ActiveMQServerLogger.LOGGER.debug("login " + this.user);
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.loginSucceeded;
        if (result) {
            this.principals.add(new UserPrincipal(this.user));
            block0: for (Map.Entry<Object, Object> entry : this.roles.entrySet()) {
                String name = (String)entry.getKey();
                String[] userList = ((String)entry.getValue()).split(",");
                if (this.debug) {
                    ActiveMQServerLogger.LOGGER.debug("Inspecting role '" + name + "' with user(s): " + entry.getValue());
                }
                for (int i = 0; i < userList.length; ++i) {
                    if (!this.user.equals(userList[i])) continue;
                    this.principals.add(new RolePrincipal(name));
                    continue block0;
                }
            }
            this.subject.getPrincipals().addAll(this.principals);
        }
        this.clear();
        if (this.debug) {
            ActiveMQServerLogger.LOGGER.debug("commit, result: " + result);
        }
        return result;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            ActiveMQServerLogger.LOGGER.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.clear();
        if (this.debug) {
            ActiveMQServerLogger.LOGGER.debug("logout");
        }
        return true;
    }

    private void clear() {
        this.user = null;
        this.loginSucceeded = false;
    }
}

