/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;

public class ReloadableProperties {
    private Properties props = new Properties();
    private Map<String, String> invertedProps;
    private long reloadTime = -1L;
    private final PropertiesLoader.FileNameKey key;

    public ReloadableProperties(PropertiesLoader.FileNameKey key) {
        this.key = key;
    }

    public synchronized Properties getProps() {
        return this.props;
    }

    public synchronized ReloadableProperties obtained() {
        if (this.reloadTime < 0L || this.key.isReload() && this.hasModificationAfter(this.reloadTime)) {
            block4: {
                this.props = new Properties();
                try {
                    this.load(this.key.file(), this.props);
                    this.invertedProps = null;
                    if (this.key.isDebug()) {
                        ActiveMQServerLogger.LOGGER.debug("Load of: " + this.key);
                    }
                }
                catch (IOException e) {
                    ActiveMQServerLogger.LOGGER.error("Failed to load: " + this.key + ", reason:" + e.getLocalizedMessage());
                    if (!this.key.isDebug()) break block4;
                    ActiveMQServerLogger.LOGGER.debug("Load of: " + this.key + ", failure exception" + e);
                }
            }
            this.reloadTime = System.currentTimeMillis();
        }
        return this;
    }

    public synchronized Map<String, String> invertedPropertiesMap() {
        if (this.invertedProps == null) {
            this.invertedProps = new HashMap<String, String>(this.props.size());
            for (Map.Entry<Object, Object> val : this.props.entrySet()) {
                this.invertedProps.put((String)val.getValue(), (String)val.getKey());
            }
        }
        return this.invertedProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File source, Properties props) throws IOException {
        try (FileInputStream in = new FileInputStream(source);){
            props.load(in);
        }
    }

    private boolean hasModificationAfter(long reloadTime) {
        return this.key.file.lastModified() > reloadTime;
    }
}

